/*
 * Decompiled with CFR 0.152.
 */
package net.aepherastudios.createdefensive.item.custom;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.aepherastudios.createdefensive.item.augments.DefensiveCapabilities;
import net.aepherastudios.createdefensive.item.augments.data.IAugmentation;
import net.aepherastudios.createdefensive.screen.AugmentInventoryProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class AluminumPowerArmorItem
extends ArmorItem {
    private static final String BATTERY_TAG = "Battery";
    public static final int MAX_BATTERY = 10000;

    public AluminumPowerArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties.m_41499_(0));
    }

    public int getAugmentSlotCount() {
        return 3;
    }

    public List<ItemStack> getAugmentations(ItemStack stack) {
        ArrayList<ItemStack> augments = new ArrayList<ItemStack>();
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("Augmentations", 9)) {
            ListTag augList = tag.m_128437_("Augmentations", 10);
            for (int i = 0; i < augList.size(); ++i) {
                CompoundTag augmentTag = augList.m_128728_(i);
                ItemStack augmentStack = ItemStack.m_41712_((CompoundTag)augmentTag);
                augments.add(augmentStack);
            }
        }
        return augments;
    }

    public void setAugmentations(ItemStack stack, List<ItemStack> augments) {
        CompoundTag tag = stack.m_41784_();
        ListTag augList = new ListTag();
        for (ItemStack augment : augments) {
            CompoundTag augmentTag = new CompoundTag();
            augment.m_41739_(augmentTag);
            augList.add((Object)augmentTag);
        }
        tag.m_128365_("Augmentations", (Tag)augList);
        stack.m_41751_(tag);
    }

    public int getBattery(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_(BATTERY_TAG);
    }

    public void setBattery(ItemStack stack, int value) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(BATTERY_TAG, Math.max(0, Math.min(10000, value)));
        LazyOptional cap = stack.getCapability(DefensiveCapabilities.AUGMENT_CAPABILITY);
        cap.ifPresent(c -> tag.m_128365_("Augments", (Tag)c.serializeNBT()));
    }

    public boolean hasCharge(ItemStack stack) {
        return this.getBattery(stack) > 0;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        float fraction = (float)this.getBattery(stack) / 10000.0f;
        return Math.round(13.0f * fraction);
    }

    public int m_142159_(ItemStack stack) {
        float fraction = (float)this.getBattery(stack) / 10000.0f;
        return Mth.m_14169_((float)(fraction / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)"WORK IN PROGRESS - CAN CRASH YOU").m_130940_(ChatFormatting.RED));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack stack, EquipmentSlot slot, LivingEntity entity) {
        if (slot == this.f_265916_.m_266308_() && this.hasCharge(stack)) {
            return super.getAttributeModifiers(slot, stack);
        }
        return HashMultimap.create();
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        List<ItemStack> augmentations = this.getAugmentations(stack);
        for (ItemStack aug : augmentations) {
            Item item = aug.m_41720_();
            if (!(item instanceof IAugmentation)) continue;
            IAugmentation augmentation = (IAugmentation)item;
            augmentation.onTick(player, stack);
        }
        player.f_36095_.m_38946_();
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = super.getShareTag(stack);
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        LazyOptional cap = stack.getCapability(DefensiveCapabilities.AUGMENT_CAPABILITY);
        CompoundTag finalNbt = nbt;
        cap.ifPresent(c -> finalNbt.m_128365_("Augments", (Tag)c.serializeNBT()));
        return nbt;
    }

    public void readShareTag(ItemStack stack, CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null && nbt.m_128441_("Augments")) {
            LazyOptional cap = stack.getCapability(DefensiveCapabilities.AUGMENT_CAPABILITY);
            cap.ifPresent(c -> c.deserializeNBT(nbt.m_128469_("Augments")));
        }
    }

    public void recharge(ItemStack stack, int amount) {
        this.setBattery(stack, this.getBattery(stack) + amount);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new AugmentInventoryProvider(stack, 3);
    }
}

