/*
 * Decompiled with CFR 0.152.
 */
package net.aepherastudios.createdefensive.item.custom;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.aepherastudios.createdefensive.effect.DefensiveEffects;
import net.aepherastudios.createdefensive.item.custom.DefensiveArmorMaterials;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DefensiveArmorItem
extends ArmorItem {
    private static final Map<ArmorMaterial, MobEffectInstance> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)DefensiveArmorMaterials.SILVER, (Object)new MobEffectInstance(MobEffects.f_19605_, 600, 0, false, false, true)).put((Object)DefensiveArmorMaterials.PLATINUM, (Object)new MobEffectInstance(MobEffects.f_19606_, 600, 0, false, false, true)).put((Object)DefensiveArmorMaterials.ELECTRUM, (Object)new MobEffectInstance(MobEffects.f_19607_, 600, 0, false, false, true)).put((Object)DefensiveArmorMaterials.STARDUST, (Object)new MobEffectInstance(MobEffects.f_19605_, 600, 1, false, false, true)).put((Object)DefensiveArmorMaterials.PYRAEN, (Object)new MobEffectInstance(MobEffects.f_19606_, 600, 2, false, false, true)).put((Object)DefensiveArmorMaterials.ROSE_GOLD_CEREMONIAL, (Object)new MobEffectInstance(MobEffects.f_19598_, 600, 1, false, false, true)).put((Object)DefensiveArmorMaterials.VIOLET_GOLD_CEREMONIAL, (Object)new MobEffectInstance(MobEffects.f_19596_, 600, 1, false, false, true)).put((Object)DefensiveArmorMaterials.GOLD_CEREMONIAL, (Object)new MobEffectInstance(MobEffects.f_19595_, 600, 0, false, false, true)).put((Object)DefensiveArmorMaterials.STEEL, (Object)new MobEffectInstance(MobEffects.f_19606_, 600, 1, false, false, true)).put((Object)DefensiveArmorMaterials.ALUMINUM_POWER, (Object)new MobEffectInstance((MobEffect)DefensiveEffects.ALUMINUM_POWER.get(), 600, 0, false, false, true)).put((Object)DefensiveArmorMaterials.STEEL_POWER, (Object)new MobEffectInstance((MobEffect)DefensiveEffects.STEEL_POWER.get(), 600, 0, false, false, true)).put((Object)DefensiveArmorMaterials.NETHERITE_POWER, (Object)new MobEffectInstance((MobEffect)DefensiveEffects.NETHERITE_POWER.get(), 600, 0, false, false, true)).build();

    public DefensiveArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.m_5776_() && this.hasFullSuitOfArmorOn(player)) {
            this.evaluateArmorEffects(player);
        }
    }

    private void evaluateArmorEffects(Player player) {
        for (Map.Entry<ArmorMaterial, MobEffectInstance> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorMaterial mapArmorMaterial = entry.getKey();
            MobEffectInstance mapStatusEffect = entry.getValue();
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffect);
        }
    }

    private void addStatusEffectForMaterial(Player player, ArmorMaterial mapArmorMaterial, MobEffectInstance mapStatusEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapStatusEffect.m_19544_());
        if (this.hasCorrectArmorOn(mapArmorMaterial, player) && !hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(mapStatusEffect));
        }
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack breastplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !breastplate.m_41619_() && !leggings.m_41619_() && !boots.m_41619_();
    }

    private boolean hasCorrectArmorOn(ArmorMaterial material, Player player) {
        for (ItemStack armorStack : player.m_150109_().f_35975_) {
            if (armorStack.m_41720_() instanceof ArmorItem) continue;
            return false;
        }
        ArmorItem boots = (ArmorItem)player.m_150109_().m_36052_(0).m_41720_();
        ArmorItem leggings = (ArmorItem)player.m_150109_().m_36052_(1).m_41720_();
        ArmorItem breastplate = (ArmorItem)player.m_150109_().m_36052_(2).m_41720_();
        ArmorItem helmet = (ArmorItem)player.m_150109_().m_36052_(3).m_41720_();
        return helmet.m_40401_() == material && breastplate.m_40401_() == material && leggings.m_40401_() == material && boots.m_40401_() == material;
    }
}

