/*
 * Decompiled with CFR 0.152.
 */
package net.aepherastudios.createdefensive.item.custom;

import net.aepherastudios.createdefensive.block.DefensiveBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class OilScannerItem
extends Item {
    public OilScannerItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_) {
            player.m_36335_().m_41524_((Item)this, 40);
            BlockPos playerPos = player.m_20183_();
            int scanRadius = 250;
            int maxDepth = playerPos.m_123342_();
            BlockPos nearestOil = null;
            double closestDistanceSq = Double.MAX_VALUE;
            for (int dx = -scanRadius; dx <= scanRadius; ++dx) {
                block1: for (int dz = -scanRadius; dz <= scanRadius; ++dz) {
                    for (int dy = 0; dy <= maxDepth; ++dy) {
                        BlockPos checkPos = playerPos.m_7918_(dx, -dy, dz);
                        BlockState state = level.m_8055_(checkPos);
                        if (!state.m_60713_((Block)DefensiveBlocks.DIRTY_RAW_CRUDE_OIL.get())) continue;
                        double distSq = dx * dx + dz * dz;
                        if (!(distSq < closestDistanceSq)) continue block1;
                        closestDistanceSq = distSq;
                        nearestOil = checkPos;
                        continue block1;
                    }
                }
            }
            ItemStack stack = player.m_21120_(hand);
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            if (nearestOil == null || Math.sqrt(closestDistanceSq) > 250.0) {
                this.spawnParticles(level, playerPos, (ParticleOptions)ParticleTypes.f_123762_, 12, 0.2);
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7cNo Oil Nearby"));
            } else {
                String ew;
                String ns;
                BlockPos oilXZ = new BlockPos(nearestOil.m_123341_(), playerPos.m_123342_(), nearestOil.m_123343_());
                int dx = oilXZ.m_123341_() - playerPos.m_123341_();
                int dz = oilXZ.m_123343_() - playerPos.m_123343_();
                double horizontalDist = Math.sqrt(dx * dx + dz * dz);
                String string = dz < 0 ? "North" : (ns = dz > 0 ? "South" : "");
                String string2 = dx < 0 ? "West" : (ew = dx > 0 ? "East" : "");
                if (horizontalDist > 100.0) {
                    this.spawnParticles(level, playerPos, (ParticleOptions)ParticleTypes.f_123744_, 10, 0.1);
                    Object dirText = "Oil to the ";
                    if (!ns.isEmpty()) {
                        dirText = (String)dirText + ns;
                    }
                    if (!ew.isEmpty()) {
                        dirText = (String)dirText + (!ns.isEmpty() ? " and " : "") + ew;
                    }
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a76" + (String)dirText)));
                } else if (horizontalDist > 0.0) {
                    this.spawnParticles(level, playerPos, (ParticleOptions)ParticleTypes.f_123810_, 15, 0.15);
                    int stepsNorthSouth = Math.abs(dz);
                    int stepsEastWest = Math.abs(dx);
                    StringBuilder message = new StringBuilder("\u00a7eOil ");
                    if (stepsNorthSouth > 0) {
                        message.append(" ").append(stepsNorthSouth).append(" steps to the ").append(ns);
                        if (stepsEastWest > 0) {
                            message.append(", ");
                        }
                    }
                    if (stepsEastWest > 0) {
                        message.append(stepsEastWest).append(" steps to the ").append(ew);
                    }
                    player.m_213846_((Component)Component.m_237113_((String)message.toString()));
                } else {
                    this.spawnParticles(level, playerPos, (ParticleOptions)ParticleTypes.f_123748_, 20, 0.25);
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7aOil Found"));
                }
            }
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    private void spawnParticles(Level level, BlockPos pos, ParticleOptions type, int count, double spread) {
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.m_123341_() + 0.5 + level.f_46441_.m_188583_() * spread;
            double y = (double)pos.m_123342_() + 1.0 + level.f_46441_.m_188583_() * spread * 0.5;
            double z = (double)pos.m_123343_() + 0.5 + level.f_46441_.m_188583_() * spread;
            ((ServerLevel)level).m_8767_(type, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

