/*
 * Decompiled with CFR 0.152.
 */
package net.aepherastudios.createdefensive.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.aepherastudios.createdefensive.item.custom.AluminumPowerArmorItem;
import net.aepherastudios.createdefensive.screen.DefensiveMenuTypes;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class AugmentMenu
extends AbstractContainerMenu {
    private final Map<Integer, ArmorSlotReference> slotMap = new HashMap<Integer, ArmorSlotReference>();
    private final List<IItemHandler> augmentInventories = new ArrayList<IItemHandler>();
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 12;

    public AugmentMenu(int id, Inventory playerInventory) {
        super((MenuType)DefensiveMenuTypes.AUGMENT_MENU.get(), id);
        Player player = playerInventory.f_35978_;
        int[][] slotPositions = new int[][]{{98, 26}, {98, 44}, {98, 62}, {116, 26}, {116, 44}, {116, 62}, {134, 26}, {134, 44}, {134, 62}, {152, 26}, {152, 44}, {152, 62}};
        EquipmentSlot[] armorSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
        AtomicInteger slotIndex = new AtomicInteger(0);
        for (EquipmentSlot armorSlot : armorSlots) {
            ItemStack armorPiece = player.m_6844_(armorSlot);
            Item item = armorPiece.m_41720_();
            if (item instanceof AluminumPowerArmorItem) {
                AluminumPowerArmorItem armor = (AluminumPowerArmorItem)item;
                List<ItemStack> savedAugments = armor.getAugmentations(armorPiece);
                armorPiece.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(cap -> {
                    this.augmentInventories.add((IItemHandler)cap);
                    for (int i = 0; i < 3; ++i) {
                        ItemStack augmentStack = i < savedAugments.size() ? (ItemStack)savedAugments.get(i) : ItemStack.f_41583_;
                        cap.insertItem(i, augmentStack, false);
                        int x = slotPositions[slotIndex.get()][0];
                        int y = slotPositions[slotIndex.get()][1];
                        this.m_38897_((Slot)new SlotItemHandler(cap, i, x, y));
                        this.slotMap.put(slotIndex.get(), new ArmorSlotReference(armorSlot, i));
                        slotIndex.getAndIncrement();
                    }
                });
                continue;
            }
            slotIndex.addAndGet(3);
        }
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    public ItemStack m_7648_(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            if (!this.m_38903_(sourceStack, 36, 48, false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 48) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public void m_6877_(Player player) {
        System.out.println("Removed Called");
        System.out.println("slotMap size: " + this.slotMap.size());
        for (Map.Entry<Integer, ArmorSlotReference> entry : this.slotMap.entrySet()) {
            int globalSlot = entry.getKey();
            ArmorSlotReference ref = entry.getValue();
            ItemStack armorStack = player.m_6844_(ref.equipmentSlot);
            Item item = armorStack.m_41720_();
            if (!(item instanceof AluminumPowerArmorItem)) continue;
            AluminumPowerArmorItem armor = (AluminumPowerArmorItem)item;
            List<ItemStack> newAugments = this.getNewAugmentsFromSlots(ref);
            System.out.println("Saving augments for slot " + ref.equipmentSlot + ": " + newAugments.size() + " augments.");
            for (ItemStack aug : newAugments) {
                System.out.println(" - " + aug);
            }
            armor.setAugmentations(armorStack, newAugments);
        }
        super.m_6877_(player);
    }

    private List<ItemStack> getNewAugmentsFromSlots(ArmorSlotReference ref) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Map.Entry<Integer, ArmorSlotReference> entry : this.slotMap.entrySet()) {
            if (!entry.getValue().equipmentSlot.equals((Object)ref.equipmentSlot)) continue;
            list.add(this.m_38853_(entry.getKey()).m_7993_());
        }
        return list;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public record ArmorSlotReference(EquipmentSlot equipmentSlot, int index) {
    }
}

