/*
 * Decompiled with CFR 0.152.
 */
package net.aepherastudios.createdefensive.screen;

import net.aepherastudios.createdefensive.block.entity.IndustrialHeaterBlockEntity;
import net.aepherastudios.createdefensive.screen.DefensiveMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;

public class IndustrialHeaterMenu
extends AbstractContainerMenu {
    private final IndustrialHeaterBlockEntity blockEntity;
    private final ContainerLevelAccess access;
    private final ContainerData data;

    public IndustrialHeaterMenu(int windowId, Inventory playerInventory, IndustrialHeaterBlockEntity blockEntity, ContainerData data) {
        super((MenuType)DefensiveMenuTypes.INDUSTRIAL_HEATER.get(), windowId);
        this.blockEntity = blockEntity;
        this.access = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        this.data = data;
        this.m_38884_(data);
        blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler(handler, 0, 80, 49)));
        this.layoutPlayerInventorySlots(playerInventory, 8, 84);
    }

    public IndustrialHeaterMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(windowId, playerInventory, (IndustrialHeaterBlockEntity)playerInventory.f_35978_.m_9236_().m_7702_(buffer.m_130135_()), (ContainerData)new SimpleContainerData(2));
    }

    public boolean isBurning() {
        return this.data.m_6413_(0) > 0;
    }

    public int getBurnLeftScaled(int pixels) {
        int burnTime = this.data.m_6413_(0);
        int totalBurnTime = this.data.m_6413_(1);
        if (totalBurnTime == 0) {
            totalBurnTime = 200;
        }
        return burnTime * pixels / totalBurnTime;
    }

    private void layoutPlayerInventorySlots(Inventory playerInventory, int leftCol, int topRow) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, leftCol + col * 18, topRow + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, leftCol + col * 18, topRow + 58));
        }
    }

    public boolean m_6875_(Player player) {
        return IndustrialHeaterMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 1 ? !this.m_38903_(itemstack1, 1, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 1, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

