/*
 * Decompiled with CFR 0.152.
 */
package net.aepherastudios.createdefensive.worldgen;

import java.util.List;
import net.aepherastudios.createdefensive.worldgen.DefensiveConfiguredFeatures;
import net.aepherastudios.createdefensive.worldgen.DefensiveFeatures;
import net.aepherastudios.createdefensive.worldgen.DefensiveOrePlacement;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class DefensivePlacedFeatures {
    public static final ResourceKey<PlacedFeature> ALUMINUM_ORE_PLACED_KEY = DefensivePlacedFeatures.registerKey("aluminum_ore_placed");
    public static final ResourceKey<PlacedFeature> SILVER_ORE_PLACED_KEY = DefensivePlacedFeatures.registerKey("silver_ore_placed");
    public static final ResourceKey<PlacedFeature> PLATINUM_ORE_PLACED_KEY = DefensivePlacedFeatures.registerKey("platinum_ore_placed");
    public static final ResourceKey<PlacedFeature> LEAD_ORE_PLACED_KEY = DefensivePlacedFeatures.registerKey("lead_ore_placed");
    public static final ResourceKey<PlacedFeature> TIN_ORE_PLACED_KEY = DefensivePlacedFeatures.registerKey("tin_ore_placed");
    public static final ResourceKey<PlacedFeature> NICKEL_ORE_PLACED_KEY = DefensivePlacedFeatures.registerKey("nickel_ore_placed");
    public static final ResourceKey<PlacedFeature> URANIUM_ORE_PLACED_KEY = DefensivePlacedFeatures.registerKey("uranium_ore_placed");
    public static final ResourceKey<PlacedFeature> OIL_LAKE_PLACED_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("createdefensive", "oil_lake_placed"));
    public static final ResourceKey<PlacedFeature> NATURAL_GAS_LAKE_PLACED_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("createdefensive", "natural_gas_lake_placed"));
    public static final ResourceKey<PlacedFeature> METEORITE_PLACED_KEY = DefensivePlacedFeatures.registerKey("meteorite_placed");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        Holder.Reference oilConfiguredFeature = configuredFeatures.m_255043_(DefensiveFeatures.OIL_LAKE_KEY);
        Holder.Reference lmgConfiguredFeature = configuredFeatures.m_255043_(DefensiveFeatures.NATURAL_GAS_LAKE_KEY);
        DefensivePlacedFeatures.register(context, ALUMINUM_ORE_PLACED_KEY, configuredFeatures.m_255043_(DefensiveConfiguredFeatures.OVERWORLD_ALUMINUM_ORE_KEY), DefensiveOrePlacement.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)80))));
        DefensivePlacedFeatures.register(context, SILVER_ORE_PLACED_KEY, configuredFeatures.m_255043_(DefensiveConfiguredFeatures.OVERWORLD_SILVER_ORE_KEY), DefensiveOrePlacement.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)40))));
        DefensivePlacedFeatures.register(context, PLATINUM_ORE_PLACED_KEY, configuredFeatures.m_255043_(DefensiveConfiguredFeatures.OVERWORLD_PLATINUM_ORE_KEY), DefensiveOrePlacement.rareOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)16))));
        DefensivePlacedFeatures.register(context, LEAD_ORE_PLACED_KEY, configuredFeatures.m_255043_(DefensiveConfiguredFeatures.OVERWORLD_LEAD_ORE_KEY), DefensiveOrePlacement.rareOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)16))));
        DefensivePlacedFeatures.register(context, TIN_ORE_PLACED_KEY, configuredFeatures.m_255043_(DefensiveConfiguredFeatures.OVERWORLD_TIN_ORE_KEY), DefensiveOrePlacement.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)16))));
        DefensivePlacedFeatures.register(context, NICKEL_ORE_PLACED_KEY, configuredFeatures.m_255043_(DefensiveConfiguredFeatures.OVERWORLD_NICKEL_ORE_KEY), DefensiveOrePlacement.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)16))));
        DefensivePlacedFeatures.register(context, URANIUM_ORE_PLACED_KEY, configuredFeatures.m_255043_(DefensiveConfiguredFeatures.OVERWORLD_URANIUM_ORE_KEY), DefensiveOrePlacement.rareOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)16))));
        PlacementModifier[] modifiers = new PlacementModifier[]{RarityFilter.m_191900_((int)250), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)-50), (VerticalAnchor)VerticalAnchor.m_158930_((int)40)), BiomeFilter.m_191561_()};
        Holder.Reference meteoriteConfigured = configuredFeatures.m_255043_(DefensiveFeatures.METEORITE_KEY);
        PlacementModifier[] meteoriteModifiers = new PlacementModifier[]{CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)50), (VerticalAnchor)VerticalAnchor.m_158922_((int)150)), BiomeFilter.m_191561_()};
        DefensivePlacedFeatures.register(context, METEORITE_PLACED_KEY, meteoriteConfigured, List.of(meteoriteModifiers));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("createdefensive", name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

