/*
 * Decompiled with CFR 0.152.
 */
package net.aepherastudios.createdefensive.worldgen.features;

import com.mojang.serialization.Codec;
import net.aepherastudios.createdefensive.worldgen.config.MeteoriteConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class MeteoriteFeature
extends Feature<MeteoriteConfig> {
    public MeteoriteFeature(Codec<MeteoriteConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<MeteoriteConfig> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource random = context.m_225041_();
        MeteoriteConfig config = (MeteoriteConfig)context.m_159778_();
        int radius = config.radius();
        int inner = config.innerThickness();
        Block coreBlock = (Block)config.coreBlock().m_203334_();
        Block middleBlock = (Block)config.middleBlock().m_203334_();
        Block shellBlock = (Block)config.shellBlock().m_203334_();
        Block crackedShell = config.crackedShellBlock() != null ? (Block)config.crackedShellBlock().m_203334_() : shellBlock;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double dist = Math.sqrt(x * x + y * y + z * z);
                    BlockPos targetPos = pos.m_7918_(x, y, z);
                    if (dist <= 0.5) {
                        world.m_7731_(targetPos, coreBlock.m_49966_(), 2);
                        continue;
                    }
                    if (dist <= (double)inner + 0.5) {
                        if (config.middleReplacementBlock() != null && random.m_188501_() < config.middleReplacementChance()) {
                            world.m_7731_(targetPos, ((Block)config.middleReplacementBlock().m_203334_()).m_49966_(), 2);
                            continue;
                        }
                        world.m_7731_(targetPos, middleBlock.m_49966_(), 2);
                        continue;
                    }
                    if (!(dist <= (double)radius)) continue;
                    if (random.m_188501_() < config.shellCrackChance()) {
                        world.m_7731_(targetPos, crackedShell.m_49966_(), 2);
                        continue;
                    }
                    world.m_7731_(targetPos, shellBlock.m_49966_(), 2);
                }
            }
        }
        return true;
    }
}

