/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.bwt_hct.blocks;

import btwr.btwr_sl.tag.BTWRConventionalTags;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.HempCropBlock;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class HempCropBlockManager {
    private static final HempCropBlockManager INSTANCE = new HempCropBlockManager();
    private static final float BASE_GROWTH_CHANCE = 0.1f;
    private static final class_2758 AGE = HempCropBlock.field_10835;
    public static final class_2746 IS_TOP = class_2746.method_11825((String)"is_top");

    private HempCropBlockManager() {
    }

    public static HempCropBlockManager getInstance() {
        return INSTANCE;
    }

    public void onRandomTick(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, class_2248 hemp) {
        if (!world.method_8311(pos) && world.method_22339(pos) < 15 && !this.isValidAlternateLightSourceAbove((class_1937)world, pos)) {
            return;
        }
        class_2248 soilBlock = world.method_8320(pos.method_10074()).method_26204();
        if (soilBlock == null) {
            return;
        }
        if (soilBlock.isBlockHydratedForPlantGrowthOn((class_1937)world, pos.method_10074()) || soilBlock.method_9564().method_26164(BTWRConventionalTags.Blocks.ALWAYS_FERTILE_SOIL)) {
            if ((Integer)state.method_11654((class_2769)AGE) < 7) {
                this.attemptGrowth((class_1937)world, pos, state, random, soilBlock, hemp);
            } else if (world.method_22347(pos.method_10084())) {
                this.attemptTopGrowth((class_1937)world, pos, state, random, soilBlock, hemp);
            }
        }
    }

    private void attemptGrowth(class_1937 world, class_2338 pos, class_2680 state, class_5819 random, class_2248 soilBlock, class_2248 hemp) {
        float chance = 0.1f * soilBlock.getPlantGrowthOnMultiplier(world, pos.method_10074(), hemp);
        if (random.method_43057() <= chance) {
            this.incrementGrowthLevel(world, pos, state, hemp);
        }
    }

    private void attemptTopGrowth(class_1937 world, class_2338 pos, class_2680 state, class_5819 random, class_2248 soilBlock, class_2248 hemp) {
        float topGrowthChance = 0.025f * soilBlock.getPlantGrowthOnMultiplier(world, pos.method_10074(), hemp);
        if (random.method_43057() <= topGrowthChance) {
            world.method_8652(pos.method_10084(), (class_2680)((class_2680)state.method_11657((class_2769)IS_TOP, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(7)), 2);
            soilBlock.notifyOfFullStagePlantGrowthOn(world, pos.method_10074(), hemp);
        }
    }

    private void incrementGrowthLevel(class_1937 world, class_2338 pos, class_2680 state, class_2248 hemp) {
        class_2248 blockBelow;
        int newAge = (Integer)state.method_11654((class_2769)AGE) + 1;
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(newAge)), 2);
        if (newAge == 7 && (blockBelow = world.method_8320(pos.method_10074()).method_26204()) != null) {
            blockBelow.notifyOfFullStagePlantGrowthOn(world, pos.method_10074(), hemp);
        }
    }

    private boolean isValidAlternateLightSourceAbove(class_1937 world, class_2338 pos) {
        return this.isLitLightBlock(world, pos.method_10084()) || this.isLitLightBlock(world, pos.method_10086(2));
    }

    private boolean isLitLightBlock(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).equals(BwtBlocks.lightBlockBlock.method_9564().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)));
    }
}

