/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.bwt_hct.mixin;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.MechPowerBlockBase;
import com.bwt.items.BwtItems;
import com.bwt.recipes.BlockIngredient;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.saw.SawRecipe;
import com.bwt.recipes.saw.SawRecipeInput;
import com.bwt.sounds.BwtSoundEvents;
import com.bwt.tags.BwtBlockTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1264;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3718;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.ivangeevo.bwt_hct.util.SawLikeBlockConstants;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3718.class})
public abstract class StonecutterBlockMixin
extends class_2248
implements MechPowerBlockBase,
SawLikeBlockConstants {
    @Unique
    private static class_2753 FACING = class_2741.field_12525;

    public StonecutterBlockMixin(class_4970.class_2251 settings) {
        super(settings);
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;with(Lnet/minecraft/state/property/Property;Ljava/lang/Comparable;)Ljava/lang/Object;"), index=0)
    private class_2769<class_2350> injected(class_2769<class_2350> par1) {
        return FACING;
    }

    @Inject(method={"appendProperties"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAppendProperties(class_2689.class_2690<class_2248, class_2680> builder, CallbackInfo ci) {
        ci.cancel();
    }

    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    @Inject(method={"getPlacementState"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetPlacementState(class_1750 ctx, CallbackInfoReturnable<class_2680> cir) {
        cir.setReturnValue((Object)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_7715().method_10153())).method_11657((class_2769)MECH_POWERED, (Comparable)Boolean.valueOf(false))));
    }

    @Inject(method={"rotate"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRotate(class_2680 state, class_2470 rotation, CallbackInfoReturnable<class_2680> cir) {
        cir.setReturnValue((Object)((class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)))));
    }

    @Inject(method={"mirror"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMirror(class_2680 state, class_2415 mirror, CallbackInfoReturnable<class_2680> cir) {
        cir.setReturnValue((Object)state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING))));
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        world.method_39279(pos, (class_2248)this, 10);
    }

    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (class_265)COLLISION_SHAPES.get(((class_2350)state.method_11654((class_2769)FACING)).method_10146());
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (class_265)OUTLINE_SHAPES.get(((class_2350)state.method_11654((class_2769)FACING)).method_10146());
    }

    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        this.scheduleUpdateIfRequired(world, state, pos);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        boolean bReceivingPower = this.isReceivingMechPower((class_1937)world, state, pos);
        boolean bOn = this.isMechPowered(state);
        if (bOn != bReceivingPower) {
            this.emitSawParticles((class_1937)world, state, pos);
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)MECH_POWERED, (Comparable)Boolean.valueOf(bReceivingPower)));
            if (bReceivingPower) {
                this.playBangSound((class_1937)world, pos);
                this.scheduleUpdateIfRequired((class_1937)world, state, pos);
            }
        } else if (bOn) {
            this.sawBlockToFront((class_1937)world, state, pos);
        }
    }

    void emitSawParticles(class_1937 world, class_2680 state, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_265 bladeFace = ((class_265)BLADE_SHAPES.get(facing.method_10146())).method_52620().method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        double bladeMaxX = bladeFace.method_1105(class_2350.class_2351.field_11048);
        double bladeMaxY = bladeFace.method_1105(class_2350.class_2351.field_11052);
        double bladeMaxZ = bladeFace.method_1105(class_2350.class_2351.field_11051);
        double bladeMinX = bladeFace.method_1091(class_2350.class_2351.field_11048);
        double bladeMinY = bladeFace.method_1091(class_2350.class_2351.field_11052);
        double bladeMinZ = bladeFace.method_1091(class_2350.class_2351.field_11051);
        double fBladeXPos = (bladeMaxX + bladeMinX) / 2.0;
        double fBladeYPos = (bladeMaxY + bladeMinY) / 2.0;
        double fBladeZPos = (bladeMaxZ + bladeMinZ) / 2.0;
        for (int counter = 0; counter < 5; ++counter) {
            double smokeX = fBladeXPos + (double)(world.field_9229.method_43057() - 0.5f) * (bladeMaxX - bladeMinX);
            double smokeY = fBladeYPos + (double)(world.field_9229.method_43057() * 0.1f) * (bladeMaxY - bladeMinY);
            double smokeZ = fBladeZPos + (double)(world.field_9229.method_43057() - 0.5f) * (bladeMaxZ - bladeMinZ);
            world.method_8406((class_2394)class_2398.field_11251, smokeX, smokeY, smokeZ, 0.0, 0.0, 0.0);
        }
    }

    protected void sawBlockToFront(class_1937 world, class_2680 state, class_2338 pos) {
        BlockIngredient blockIngredient;
        class_2338 targetPos = pos.method_10093((class_2350)state.method_11654((class_2769)FACING));
        class_2680 targetState = world.method_8320(targetPos);
        if (targetState.method_26164(class_3481.field_51989)) {
            return;
        }
        SawRecipeInput recipeInput = new SawRecipeInput(targetState.method_26204());
        Optional<SawRecipe> recipe = world.method_8433().method_8132(BwtRecipes.SAW_RECIPE_TYPE, (class_9695)recipeInput, world).map(class_8786::comp_1933);
        if (recipe.isEmpty()) {
            if (targetState.method_26164(BwtBlockTags.SAW_BREAKS_NO_DROPS)) {
                world.method_22352(targetPos, false);
                this.playBangSound(world, pos);
                return;
            }
            if (targetState.method_26164(BwtBlockTags.SAW_BREAKS_DROPS_LOOT)) {
                world.method_22352(targetPos, true);
                this.playBangSound(world, pos);
                return;
            }
            if (!targetState.method_26164(BwtBlockTags.SURVIVES_SAW_BLOCK)) {
                this.breakSaw(world, pos);
            }
            return;
        }
        List results = recipe.get().getResults();
        if (targetState.method_26204() instanceof class_2482 && targetState.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12682) {
            results.forEach(result -> result.method_7939(result.method_7947() * 2));
        }
        if ((blockIngredient = recipe.get().getIngredient()).test(BwtBlocks.companionSlabBlock) && ((class_2350)state.method_11654((class_2769)FACING)).method_10166().method_10179()) {
            return;
        }
        if (blockIngredient.test(BwtBlocks.companionCubeBlock)) {
            world.method_8396(null, pos, BwtSoundEvents.COMPANION_CUBE_DEATH, class_3419.field_15245, 1.0f, 1.0f);
            if (((class_2350)state.method_11654((class_2769)FACING)).method_10166().method_10179()) {
                ((class_1799)results.get(0)).method_7939(1);
                world.method_8501(targetPos, BwtBlocks.companionSlabBlock.method_9564());
            } else {
                world.method_22352(targetPos, false);
            }
        } else {
            world.method_22352(targetPos, false);
        }
        this.playBangSound(world, pos);
        if (targetState.method_28498((class_2769)class_2741.field_12485) && ((class_2771)targetState.method_11654((class_2769)class_2741.field_12485)).equals((Object)class_2771.field_12682)) {
            results.forEach(stack -> stack.method_7939(stack.method_7947() * 2));
        }
        class_1264.method_17349((class_1937)world, (class_2338)targetPos, (class_2371)class_2371.method_10212((Object)class_1799.field_8037, (Object[])results.toArray(new class_1799[0])));
    }

    public void breakSaw(class_1937 world, class_2338 pos) {
        this.dropItemsOnBreak(world, pos);
        world.method_22352(pos, false);
        this.playBangSound(world, pos, 1.0f);
    }

    public void dropItemsOnBreak(class_1937 world, class_2338 pos) {
        class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)class_2371.method_10212((Object)class_1799.field_8037, (Object[])new class_1799[]{new class_1799((class_1935)BwtItems.gearItem, 1), new class_1799((class_1935)class_1802.field_8600, 2), new class_1799((class_1935)BwtItems.sawDustItem, 2), new class_1799((class_1935)class_1802.field_8620, 2), new class_1799((class_1935)BwtItems.strapItem, 2)}));
    }

    protected void scheduleUpdateIfRequired(class_1937 world, class_2680 state, class_2338 pos) {
        if (this.isMechPowered(state) != this.isReceivingMechPower(world, state, pos)) {
            world.method_39279(pos, (class_2248)this, 10);
            return;
        }
        if (!this.isMechPowered(state)) {
            return;
        }
        class_2338 targetPos = pos.method_10093((class_2350)state.method_11654((class_2769)FACING));
        class_2680 targetState = world.method_8320(targetPos);
        if (!targetState.method_26164(class_3481.field_51989)) {
            world.method_39279(pos, (class_2248)this, 15 + world.field_9229.method_43048(4));
        }
    }
}

