/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.bwt_hct.emi.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import org.ivangeevo.bwt_hct.emi.BWT_HCTEmiPlugin;
import org.ivangeevo.bwt_hct.recipes.mill_stone.ModernMillStoneRecipe;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EmiModernMillstoneRecipe
implements EmiRecipe {
    public static final EmiTexture EMPTY_GEAR = new EmiTexture(BWT_HCTEmiPlugin.WIDGETS, 0, 0, 14, 14);
    public static final EmiTexture FULL_GEAR = new EmiTexture(BWT_HCTEmiPlugin.WIDGETS, 14, 0, 14, 14);
    private final EmiRecipeCategory category;
    private final class_2960 id;
    private final List<EmiIngredient> ingredients;
    private final List<EmiStack> results;
    private final int displayRows;

    public EmiModernMillstoneRecipe(EmiRecipeCategory category, class_8786<ModernMillStoneRecipe> recipeEntry) {
        this(category, recipeEntry.comp_1932(), (ModernMillStoneRecipe)recipeEntry.comp_1933());
    }

    public EmiModernMillstoneRecipe(EmiRecipeCategory category, class_2960 id, ModernMillStoneRecipe recipe) {
        this.category = category;
        this.id = id;
        this.ingredients = recipe.method_8117().stream().map(BWT_HCTEmiPlugin::from).toList();
        this.results = recipe.getResults().stream().map(EmiStack::of).toList();
        this.displayRows = IntStream.of((int)Math.ceil((double)this.ingredients.size() / 3.0), (int)Math.ceil((double)this.results.size() / 3.0), 1).max().orElse(1);
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.ingredients;
    }

    public List<EmiStack> getOutputs() {
        return this.results;
    }

    public int getDisplayWidth() {
        return 140;
    }

    public int getDisplayHeight() {
        return this.displayRows * 18;
    }

    public void addWidgets(WidgetHolder widgets) {
        int y = 0;
        int x = 0;
        int i = 0;
        widgets.addTexture(EMPTY_GEAR, 60, y).tooltip(List.of(EmiTooltipComponents.of((class_2561)class_2561.method_43470((String)this.id.toString()))));
        widgets.addAnimatedTexture(FULL_GEAR, 60, y, 19500, false, true, false);
        int constantInputSlots = 3;
        int constantOutputSlots = 3;
        for (EmiIngredient emiIngredient : this.ingredients) {
            widgets.addSlot(emiIngredient, x + i % 3 * 18, y + i / 3 * 18);
            ++i;
        }
        while (i < constantInputSlots) {
            widgets.addSlot((EmiIngredient)EmiStack.EMPTY, x + i % 3 * 18, y + i / 3 * 18);
            ++i;
        }
        i = 0;
        x = 80;
        for (EmiIngredient emiIngredient : this.results) {
            widgets.addSlot(emiIngredient, x + i * 18, y).recipeContext((EmiRecipe)this);
            ++i;
        }
        while (i < constantOutputSlots) {
            widgets.addSlot((EmiIngredient)EmiStack.EMPTY, x + i % 3 * 18, y + i / 3 * 18).recipeContext((EmiRecipe)this);
            ++i;
        }
    }
}

