/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.bwt_hct.entities.block;

import com.bwt.blocks.mill_stone.MillStoneBlock;
import com.bwt.utils.OrderedRecipeMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.ivangeevo.bwt_hct.blocks.ModBlocks;
import org.ivangeevo.bwt_hct.blocks.blocks.ModernMillStoneBlock;
import org.ivangeevo.bwt_hct.entities.ModBlockEntities;
import org.ivangeevo.bwt_hct.recipes.mill_stone.ModernMillStoneRecipe;
import org.ivangeevo.bwt_hct.recipes.mill_stone.SingleCountMillStoneRecipeInput;
import org.ivangeevo.bwt_hct.util.SingleCountInventory;

public class ModernMillStoneBE
extends class_2586
implements class_1263 {
    protected int grindProgressTime;
    public static final int timeToGrind = 200;
    public final Inventory inventory = new Inventory(1);
    public final InventoryStorage inventoryWrapper = InventoryStorage.of((class_1263)this.inventory, (class_2350)class_2350.field_11036);
    final class_1863.class_7266<SingleCountMillStoneRecipeInput, ModernMillStoneRecipe> matchGetter = class_1863.method_42302((class_3956)ModernMillStoneRecipe.Type.INSTANCE);

    public ModernMillStoneBE(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.modernMillStoneEntity, pos, state);
    }

    public boolean onUseByPlayer(class_1657 player) {
        class_1799 held = player.method_6047();
        if (!this.inventory.method_5442()) {
            this.retrieveItem(this.field_11863, player);
            return true;
        }
        if (this.inventory.method_5442() && !held.method_7960() && this.getRecipeFor(held).isPresent()) {
            class_1799 inserted = held.method_46651(1);
            this.method_5447(0, inserted);
            held.method_7934(1);
            assert (this.field_11863 != null);
            this.setFull(this.field_11863, true);
            return true;
        }
        return false;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ModernMillStoneBE blockEntity) {
        if (!state.method_27852(ModBlocks.modernMillStoneBlock) || !((Boolean)state.method_11654((class_2769)MillStoneBlock.MECH_POWERED)).booleanValue()) {
            return;
        }
        SingleCountMillStoneRecipeInput recipeInput = new SingleCountMillStoneRecipeInput((List<class_1799>)blockEntity.inventory.method_54454());
        List matches = world.method_8433().method_17877((class_3956)ModernMillStoneRecipe.Type.INSTANCE, (class_9695)recipeInput, world);
        if (matches.isEmpty()) {
            if (blockEntity.grindProgressTime != 0) {
                blockEntity.grindProgressTime = 0;
                blockEntity.method_5431();
            }
            return;
        }
        ++blockEntity.grindProgressTime;
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)ModernMillStoneBlock.FULL, (Comparable)Boolean.valueOf(true)));
        if (blockEntity.grindProgressTime < 200) {
            return;
        }
        blockEntity.grindProgressTime = 0;
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)ModernMillStoneBlock.FULL, (Comparable)Boolean.valueOf(false)));
        blockEntity.method_5431();
        OrderedRecipeMatcher.getFirstRecipe((List)matches, (class_2371)blockEntity.inventory.method_54454(), match -> blockEntity.completeRecipe((ModernMillStoneRecipe)match, world, pos));
    }

    public Optional<class_8786<ModernMillStoneRecipe>> getRecipeFor(class_1799 stack) {
        if (stack.method_7960()) {
            return Optional.empty();
        }
        return this.matchGetter.method_42303((class_9695)new SingleCountMillStoneRecipeInput(Collections.singletonList(stack)), this.field_11863);
    }

    public boolean completeRecipe(ModernMillStoneRecipe recipe, class_1937 world, class_2338 pos) {
        try (Transaction transaction = Transaction.openOuter();){
            ItemVariant itemVariant = (ItemVariant)StorageUtil.findStoredResource((Storage)this.inventoryWrapper, input -> ((class_1856)recipe.method_8117().getFirst()).method_8093(input.toStack()));
            long taken = this.inventoryWrapper.extract((Object)itemVariant, 1L, (TransactionContext)transaction);
            if (taken == 0L) {
                transaction.abort();
                boolean bl = false;
                return bl;
            }
            for (class_1799 result : recipe.getResults()) {
                ModernMillStoneBE.ejectItem(world, result, pos);
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    public boolean addItem(class_1799 stack) {
        try (Transaction tx = Transaction.openOuter();){
            if (this.inventoryWrapper.insert((Object)ItemVariant.of((class_1799)stack), 1L, (TransactionContext)tx) == (long)stack.method_7947()) {
                tx.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void retrieveItem(class_1937 world, class_1657 player) {
        try (Transaction tx = Transaction.openOuter();){
            ItemVariant variant = ItemVariant.of((class_1799)this.inventory.method_5438(0));
            long extracted = this.inventoryWrapper.extract((Object)variant, 1L, (TransactionContext)tx);
            if (extracted != 0L) {
                player.method_31548().method_7398(variant.toStack());
                this.setFull(world, false);
                tx.commit();
            }
        }
    }

    public static void ejectItem(class_1937 world, class_1799 stack, class_2338 pos) {
        class_243 centerPos = pos.method_46558();
        class_243 horizontalUnitVector = new class_243(1.0, 0.0, 1.0);
        double angle = Math.toRadians(world.field_9229.method_39332(0, 359));
        double distToEdge = Math.min(0.5 / Math.abs(Math.cos(angle)), 0.5 / Math.abs(Math.sin(angle)));
        class_243 itemPos = horizontalUnitVector.method_1024((float)angle).method_1021(distToEdge + 0.01).method_1019(centerPos);
        class_243 itemVelocity = horizontalUnitVector.method_1024((float)angle).method_1021((double)world.field_9229.method_43057() * 0.0125 + (double)0.1f).method_1031(0.0, world.field_9229.method_43059() * 0.0125 + (double)0.05f, 0.0);
        class_1542 itemEntity = new class_1542(world, itemPos.method_10216(), itemPos.method_10214(), itemPos.method_10215(), stack);
        itemEntity.method_18799(itemVelocity);
        world.method_8649((class_1297)itemEntity);
    }

    private void setFull(class_1937 world, boolean value) {
        world.method_8501(this.field_11867, (class_2680)world.method_8320(this.field_11867).method_11657((class_2769)ModernMillStoneBlock.FULL, (Comparable)Boolean.valueOf(value)));
        this.updateListeners();
    }

    private void updateListeners() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory.method_7659(nbt.method_10554("Inventory", 10), registryLookup);
        this.grindProgressTime = nbt.method_10550("grindProgressTime");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("Inventory", (class_2520)this.inventory.method_7660(registryLookup));
        nbt.method_10569("grindProgressTime", this.grindProgressTime);
    }

    public int method_5439() {
        return this.inventory.method_5439();
    }

    public boolean method_5442() {
        return this.inventory.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return this.inventory.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.inventory.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.inventory.method_5441(slot);
    }

    public int method_5444() {
        return this.inventory.method_5444();
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.method_5447(slot, stack);
    }

    public boolean method_5443(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public int method_58350(class_1799 stack) {
        return this.inventory.method_58350(stack);
    }

    public void method_5448() {
        this.inventory.method_5448();
    }

    public class Inventory
    extends SingleCountInventory {
        public Inventory(int size) {
            super(size);
        }

        public void method_5431() {
            ModernMillStoneBE.this.method_5431();
        }
    }
}

