/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.fabric.example;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EXTServer
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"CobbleExtraData");

    public void onInitialize() {
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.NORMAL, event -> {
            try {
                this.handlePokemonEvent(event.getPokemon(), event.getPlayer());
            }
            catch (Exception e) {
                this.logError("POKEMON_CAPTURED", e);
            }
            return null;
        });
        CobblemonEvents.STARTER_CHOSEN.subscribe(Priority.NORMAL, event -> {
            try {
                this.handlePokemonEvent(event.getPokemon(), event.getPlayer());
            }
            catch (Exception e) {
                this.logError("STARTER_CHOSEN", e);
            }
            return null;
        });
        LOGGER.info("Server-side initialization complete.");
    }

    private void handlePokemonEvent(Pokemon pokemon, class_3222 player) {
        try {
            class_3218 world = (class_3218)player.method_37908();
            LocalDate currentDate = LocalDate.now();
            String metDate = currentDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
            pokemon.getPersistentData().method_10582("MetDate", metDate);
            class_1959 biome = (class_1959)world.method_23753(player.method_24515()).comp_349();
            class_2960 biomeId = world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
            String biomeName = biomeId.toString();
            pokemon.getPersistentData().method_10582("MetLocation", biomeName);
            int metLevel = pokemon.getLevel();
            pokemon.getPersistentData().method_10569("MetLevel", metLevel);
            pokemon.getPersistentData().method_10582("OriginGame", "Cobblemon");
            LOGGER.info("Pok\u00e9mon event handled successfully:");
            LOGGER.info("Met Date: {}", (Object)metDate);
            LOGGER.info("Met Biome: {}", (Object)biomeName);
            LOGGER.info("Met Level: {}", (Object)metLevel);
        }
        catch (Exception e) {
            this.logError("PokemonEvent", e);
        }
    }

    private void logError(String eventName, Exception e) {
        LOGGER.error("An error occurred in the {} event handler:", (Object)eventName, (Object)e);
    }
}

