/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.fabric.example;

import com.cobblemon.fabric.example.OriginGameMapper;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PokemonInfoScreen
extends class_437 {
    private final Pokemon pokemon;
    private class_2960 pokemonSprite;
    private class_2960 originMark;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"CobbleExtraData");

    protected PokemonInfoScreen(Pokemon pokemon) {
        super((class_2561)class_2561.method_43470((String)"Pok\u00e9mon Info"));
        this.pokemon = pokemon;
        String originMarkSprite = pokemon.getPersistentData().method_10545("OriginGame") ? pokemon.getPersistentData().method_10558("OriginGame").toLowerCase() : "cobblemon";
        Object speciesName = pokemon.getSpecies().getName().toLowerCase();
        String formName = pokemon.getForm().getName().toLowerCase();
        Object spritePath = "textures/sprites/";
        spritePath = pokemon.getShiny() ? (String)spritePath + "shiny/" : (String)spritePath + "regular/";
        if (!formName.isEmpty() && !formName.equals("normal")) {
            speciesName = (String)speciesName + "-" + formName;
        }
        this.pokemonSprite = class_2960.method_60655((String)"cobblemonextradata", (String)((String)spritePath + (String)speciesName + ".png"));
        this.originMark = class_2960.method_60655((String)"cobblemonextradata", (String)("textures/origin/" + originMarkSprite + ".png"));
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics, mouseX, mouseY, partialTicks);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        int panelWidth = 220;
        int panelHeight = 120;
        int x = (this.field_22789 - panelWidth) / 2;
        int y = (this.field_22790 - panelHeight) / 2;
        int spriteWidth = 68;
        int spriteHeight = 56;
        int spriteX = (this.field_22789 - spriteWidth) / 2;
        int spriteY = y - spriteHeight;
        this.drawTexture(guiGraphics, this.pokemonSprite, spriteX, spriteY, spriteWidth, spriteHeight);
        guiGraphics.method_25294(x, y, x + panelWidth, y + panelHeight, Integer.MIN_VALUE);
        guiGraphics.method_25294(x + 2, y + 2, x + panelWidth + 2, y + panelHeight + 2, 0x20000000);
        guiGraphics.method_25294(x - 1, y - 1, x + panelWidth + 1, y, -5592406);
        guiGraphics.method_25294(x - 1, y + panelHeight, x + panelWidth + 1, y + panelHeight + 1, -5592406);
        guiGraphics.method_25294(x - 1, y, x, y + panelHeight, -5592406);
        guiGraphics.method_25294(x + panelWidth, y, x + panelWidth + 1, y + panelHeight, -5592406);
        int textX = x + 10;
        int textY = y + 10;
        guiGraphics.method_51433(this.field_22793, "Pok\u00e9mon Info", textX, textY, 0xFFFFFF, true);
        String originGame = this.pokemon.getPersistentData().method_10545("OriginGame") ? this.pokemon.getPersistentData().method_10558("OriginGame").toLowerCase() : "cobblemon";
        String regionName = OriginGameMapper.getRegion(originGame);
        guiGraphics.method_51433(this.field_22793, "This Pok\u00e9mon originated from " + regionName, textX, textY + 20, 0xFFFFFF, true);
        String dateString = this.pokemon.getPersistentData().method_10545("MetDate") ? this.pokemon.getPersistentData().method_10558("MetDate") : "Unknown";
        guiGraphics.method_51433(this.field_22793, dateString, textX, textY + 40, 0xFFFFFF, true);
        String metLocation = this.pokemon.getPersistentData().method_10558("MetLocation");
        if (!metLocation.contains(":")) {
            metLocation = "Cobblemon Transporter";
        } else {
            metLocation = metLocation.substring(metLocation.indexOf(":") + 1);
            metLocation = metLocation.replace("_", " ");
            metLocation = this.capitalizeEachWord(metLocation);
        }
        guiGraphics.method_51433(this.field_22793, metLocation, textX, textY + 60, 0xFFFFFF, true);
        int metLevel = this.pokemon.getPersistentData().method_10545("MetLevel") ? this.pokemon.getPersistentData().method_10550("MetLevel") : this.pokemon.getLevel();
        guiGraphics.method_51433(this.field_22793, "Met at Lv. " + metLevel + ".", textX, textY + 80, 0xFFFFFF, true);
        int originMarkSize = 16;
        int originMarkX = x + panelWidth - originMarkSize - 5;
        int originMarkY = y + panelHeight - originMarkSize - 5;
        this.drawTexture(guiGraphics, this.originMark, originMarkX, originMarkY, originMarkSize, originMarkSize);
    }

    private String capitalizeEachWord(String text) {
        String[] words = text.split(" ");
        StringBuilder capitalized = new StringBuilder();
        for (String word : words) {
            capitalized.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return capitalized.toString().trim();
    }

    private void drawTexture(class_332 guiGraphics, class_2960 texture, int x, int y, int width, int height) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        guiGraphics.method_25290(texture, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    public boolean method_25422() {
        return true;
    }
}

