/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.util.Utils;
import com.kingpixel.ultraeconomy.commands.Register;
import com.kingpixel.ultraeconomy.config.Config;
import com.kingpixel.ultraeconomy.config.Currencies;
import com.kingpixel.ultraeconomy.config.Lang;
import com.kingpixel.ultraeconomy.database.DatabaseFactory;
import com.kingpixel.ultraeconomy.manager.PlayerMessageQueueManager;
import com.kingpixel.ultraeconomy.models.Account;
import com.kingpixel.ultraeconomy.placeholders.PlaceHolders;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;

public class UltraEconomy
implements ModInitializer {
    public static final String MOD_ID = "ultraeconomy";
    public static final String PATH = "/config/ultraeconomy";
    public static MinecraftServer server;
    public static Config config;
    public static Lang lang;
    public static final ExecutorService ULTRA_ECONOMY_EXECUTOR;
    public static final ScheduledExecutorService ULTRA_ECONOMY_SCHEDULER;
    public static boolean migrationDone;

    public void onInitialize() {
        File folder = Utils.getAbsolutePath((String)PATH);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        UltraEconomy.load();
        this.events();
        this.tasks();
        PlaceHolders.register();
    }

    public static void load() {
        config.init();
        lang.init();
        Currencies.init();
        DatabaseFactory.init(config.getDatabase());
    }

    public void events() {
        ServerPlayerEvents.JOIN.register(player -> CompletableFuture.runAsync(() -> {
            Account account = DatabaseFactory.INSTANCE.getAccount(player.method_5667());
            DatabaseFactory.CACHE_ACCOUNTS.put((Object)player.method_5667(), (Object)account);
            account.fix();
            DatabaseFactory.INSTANCE.saveOrUpdateAccount(account);
        }, ULTRA_ECONOMY_EXECUTOR).exceptionally(e -> {
            e.printStackTrace();
            return null;
        }));
        ServerPlayerEvents.LEAVE.register(player -> {
            if (server.method_3750() || server.method_16043()) {
                return;
            }
            DatabaseFactory.CACHE_ACCOUNTS.invalidate((Object)player.method_5667());
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            UltraEconomy.server = server;
            config.getMigration().startMigration();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            DatabaseFactory.INSTANCE.flushCache();
            DatabaseFactory.INSTANCE.disconnect();
            CobbleUtils.shutdownAndAwait((ExecutorService)ULTRA_ECONOMY_EXECUTOR);
            CobbleUtils.shutdownAndAwait((ExecutorService)PlayerMessageQueueManager.SCHEDULER);
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> Register.register((CommandDispatcher<class_2168>)dispatcher));
    }

    private void tasks() {
        ULTRA_ECONOMY_SCHEDULER.scheduleAtFixedRate(() -> DatabaseFactory.CACHE_ACCOUNTS.asMap().values().forEach(account -> DatabaseFactory.INSTANCE.saveOrUpdateAccount((Account)account)), 60L, 30L, TimeUnit.SECONDS);
    }

    static {
        config = new Config();
        lang = new Lang();
        ULTRA_ECONOMY_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setNameFormat("ultra economy-executor-%d").setDaemon(true).build());
        ULTRA_ECONOMY_SCHEDULER = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("ultra economy-scheduler-%d").setDaemon(true).build());
    }
}

