/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.api;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.messages.HiperMessage;
import com.kingpixel.cobbleutils.command.suggests.CobbleUtilsSuggests;
import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.config.Currencies;
import com.kingpixel.ultraeconomy.database.DatabaseFactory;
import com.kingpixel.ultraeconomy.exceptions.UnknownCurrencyException;
import com.kingpixel.ultraeconomy.manager.PlayerMessageQueueManager;
import com.kingpixel.ultraeconomy.models.Account;
import com.kingpixel.ultraeconomy.models.Currency;
import com.kingpixel.ultraeconomy.services.VaultService;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import org.jetbrains.annotations.NotNull;

public class UltraEconomyApi {
    private static final Cache<String, Locale> localeCache = Caffeine.newBuilder().maximumSize(100L).build();

    public static Account getAccount(@NotNull UUID playerUUID) {
        return DatabaseFactory.INSTANCE.getAccount(playerUUID);
    }

    public static Account getAccount(@NotNull String playerName) {
        class_3312 userCache = CobbleUtils.server.method_3793();
        if (userCache == null) {
            return null;
        }
        Optional profile = userCache.method_14515(playerName);
        return profile.map(gameProfile -> UltraEconomyApi.getAccount(gameProfile.getId())).orElse(null);
    }

    public static boolean withdraw(@NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal amount) {
        long start = System.currentTimeMillis();
        Currency c = UltraEconomyApi.getCurrency(currency);
        if (VaultService.isPresent() && UltraEconomyApi.isPrimaryCurrency(currency)) {
            boolean result = VaultService.withdraw(uuid, currency, amount);
            DatabaseFactory.INSTANCE.setBalance(uuid, c, VaultService.getBalance(uuid, currency));
            return result;
        }
        boolean result = DatabaseFactory.INSTANCE.withdraw(uuid, c, amount);
        if (UltraEconomy.config.isNotifications()) {
            HiperMessage message = UltraEconomy.lang.getMessageWithdraw();
            message.sendMessage(uuid, UltraEconomy.lang.getPrefix(), false, false, null, message.getRawMessage().replace("%amount%", c.format(amount)));
        }
        UltraEconomyApi.aggressiveSave(uuid);
        long end = System.currentTimeMillis();
        if (UltraEconomy.config.isDebug()) {
            CobbleUtils.LOGGER.info("ultraeconomy", "Withdraw took " + (end - start) + "ms");
        }
        return result;
    }

    private static void aggressiveSave(UUID playerUUID) {
        Account account = (Account)DatabaseFactory.CACHE_ACCOUNTS.getIfPresent((Object)playerUUID);
        if (account != null) {
            UltraEconomyApi.saveAccount(account);
        }
    }

    public static Currency getCurrency(String currency) throws UnknownCurrencyException {
        return Currencies.getCurrency(currency);
    }

    private static Currency getPrimaryCurrency() {
        return Currencies.DEFAULT_CURRENCY;
    }

    public static boolean deposit(@NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal amount) {
        long start = System.currentTimeMillis();
        Currency c = UltraEconomyApi.getCurrency(currency);
        if (VaultService.isPresent() && UltraEconomyApi.isPrimaryCurrency(currency)) {
            boolean result = VaultService.deposit(uuid, currency, amount);
            DatabaseFactory.INSTANCE.setBalance(uuid, c, VaultService.getBalance(uuid, currency));
            return result;
        }
        boolean result = DatabaseFactory.INSTANCE.deposit(uuid, c, amount);
        if (UltraEconomy.config.isNotifications()) {
            HiperMessage message = UltraEconomy.lang.getMessageDeposit();
            UltraEconomyApi.runMessage(uuid, () -> message.sendMessage(uuid, UltraEconomy.lang.getPrefix(), false, false, null, message.getRawMessage().replace("%amount%", c.format(amount, UltraEconomyApi.getLocale(uuid)))));
        }
        UltraEconomyApi.aggressiveSave(uuid);
        long end = System.currentTimeMillis();
        if (UltraEconomy.config.isDebug()) {
            CobbleUtils.LOGGER.info("ultraeconomy", "Deposit took " + (end - start) + "ms");
        }
        return result;
    }

    @Nullable
    public static BigDecimal setBalance(@NotNull UUID uuid, @NotNull String currency, BigDecimal amount) {
        long start = System.currentTimeMillis();
        if (VaultService.isPresent() && UltraEconomyApi.isPrimaryCurrency(currency)) {
            VaultService.setBalance(uuid, currency, amount);
        }
        Currency c = UltraEconomyApi.getCurrency(currency);
        BigDecimal result = DatabaseFactory.INSTANCE.setBalance(uuid, c, amount);
        if (UltraEconomy.config.isNotifications()) {
            HiperMessage message = UltraEconomy.lang.getMessageSetBalance();
            UltraEconomyApi.runMessage(uuid, () -> message.sendMessage(uuid, UltraEconomy.lang.getPrefix(), false, false, null, message.getRawMessage().replace("%amount%", c.format(amount, UltraEconomyApi.getLocale(uuid)))));
        }
        UltraEconomyApi.aggressiveSave(uuid);
        long end = System.currentTimeMillis();
        if (UltraEconomy.config.isDebug()) {
            CobbleUtils.LOGGER.info("ultraeconomy", "Get balance took " + (end - start) + "ms");
        }
        return result;
    }

    @Nullable
    public static BigDecimal getBalance(@NotNull UUID uuid, @NotNull String currency) {
        if (VaultService.isPresent() && UltraEconomyApi.isPrimaryCurrency(currency)) {
            return VaultService.getBalance(uuid, currency);
        }
        Currency c = UltraEconomyApi.getCurrency(currency);
        return DatabaseFactory.INSTANCE.getBalance(uuid, c);
    }

    private static boolean isPrimaryCurrency(String currency) {
        Currency c = UltraEconomyApi.getCurrency(currency);
        return c.equals(UltraEconomyApi.getPrimaryCurrency());
    }

    public static boolean hasEnoughBalance(@NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal amount) {
        long start = System.currentTimeMillis();
        Currency c = UltraEconomyApi.getCurrency(currency);
        boolean result = VaultService.isPresent() && UltraEconomyApi.isPrimaryCurrency(currency) ? VaultService.hashEnoughBalance(uuid, currency, amount) : DatabaseFactory.INSTANCE.hasEnoughBalance(uuid, c, amount);
        if (UltraEconomy.config.isNotifications() && !result) {
            HiperMessage message = UltraEconomy.lang.getMessageNoMoney();
            UltraEconomyApi.runMessage(uuid, () -> message.sendMessage(uuid, UltraEconomy.lang.getPrefix(), false, false, null, message.getRawMessage().replace("%amount%", c.format(amount, UltraEconomyApi.getLocale(uuid)))));
        }
        long end = System.currentTimeMillis();
        if (UltraEconomy.config.isDebug()) {
            CobbleUtils.LOGGER.info("ultraeconomy", "hasEnoughBalance took " + (end - start) + "ms");
        }
        return result;
    }

    public static boolean transfer(UUID executor, UUID target, String currency, BigDecimal amount) {
        long start = System.currentTimeMillis();
        Currency curr = UltraEconomyApi.getCurrency(currency);
        String nameTarget = CobbleUtilsSuggests.SUGGESTS_PLAYER_OFFLINE_AND_ONLINE.getPlayerNameWithUUID(target);
        String nameExecutor = CobbleUtilsSuggests.SUGGESTS_PLAYER_OFFLINE_AND_ONLINE.getPlayerNameWithUUID(executor);
        if (nameExecutor == null || nameExecutor.isEmpty() || nameTarget == null || nameTarget.isEmpty()) {
            if (UltraEconomy.config.isDebug()) {
                CobbleUtils.LOGGER.error("ultraeconomy", "Executor or target name is null in transfer");
            }
            return false;
        }
        if (!curr.isTransferable()) {
            UltraEconomy.lang.getMessageCurrencyNotTransferable().sendMessage(executor, UltraEconomy.lang.getPrefix(), false);
            return false;
        }
        String currId = curr.getId();
        if (!UltraEconomyApi.hasEnoughBalance(executor, currId, amount)) {
            if (UltraEconomy.config.isDebug()) {
                CobbleUtils.LOGGER.error("ultraeconomy", "Not enough balance for executor in transfer");
            }
            return false;
        }
        if (!UltraEconomyApi.withdraw(executor, currId, amount)) {
            UltraEconomyApi.deposit(executor, currId, amount);
            if (UltraEconomy.config.isDebug()) {
                CobbleUtils.LOGGER.error("ultraeconomy", "Failed to withdraw from executor in transfer");
            }
            return false;
        }
        if (!UltraEconomyApi.deposit(target, currId, amount)) {
            UltraEconomyApi.deposit(executor, currId, amount);
            return false;
        }
        if (UltraEconomy.config.isNotifications()) {
            HiperMessage messageSender = UltraEconomy.lang.getMessagePaySuccessSender();
            UltraEconomyApi.runMessage(executor, () -> messageSender.sendMessage(executor, UltraEconomy.lang.getPrefix(), false, false, null, messageSender.getRawMessage().replace("%amount%", curr.format(amount, UltraEconomyApi.getLocale(executor))).replace("%player%", nameTarget)));
            HiperMessage messageReceiver = UltraEconomy.lang.getMessagePaySuccessReceiver();
            UltraEconomyApi.runMessage(target, () -> messageReceiver.sendMessage(target, UltraEconomy.lang.getPrefix(), false, false, null, messageReceiver.getRawMessage().replace("%amount%", curr.format(amount, UltraEconomyApi.getLocale(target))).replace("%player%", nameExecutor)));
        }
        UltraEconomyApi.aggressiveSave(executor);
        UltraEconomyApi.aggressiveSave(target);
        long end = System.currentTimeMillis();
        if (UltraEconomy.config.isDebug()) {
            CobbleUtils.LOGGER.info("ultraeconomy", "Pay took " + (end - start) + "ms");
        }
        return true;
    }

    public static void saveAccount(Account account) {
        long start = System.currentTimeMillis();
        DatabaseFactory.INSTANCE.saveOrUpdateAccount(account);
        long end = System.currentTimeMillis();
        if (UltraEconomy.config.isDebug()) {
            CobbleUtils.LOGGER.info("ultraeconomy", "Save account took " + (end - start) + "ms");
        }
    }

    public static void saveAccountSync(Account account) {
        long start = System.currentTimeMillis();
        DatabaseFactory.INSTANCE.saveOrUpdateAccountSync(account);
        long end = System.currentTimeMillis();
        if (UltraEconomy.config.isDebug()) {
            CobbleUtils.LOGGER.info("ultraeconomy", "Save account sync took " + (end - start) + "ms");
        }
    }

    public static Locale getLocale(UUID playerUUID) {
        return UltraEconomyApi.getLocale(UltraEconomy.server.method_3760().method_14602(playerUUID));
    }

    public static Locale getLocale(class_3222 player) {
        Locale serverLocale = Locale.US;
        if (player == null) {
            if (UltraEconomy.config.isDebug()) {
                CobbleUtils.LOGGER.warn("ultraeconomy", "Player is null when getting locale, returning server locale");
            }
            return serverLocale;
        }
        String localeStr = player.method_53823().comp_1951();
        if (localeStr == null || localeStr.isEmpty()) {
            if (UltraEconomy.config.isDebug()) {
                CobbleUtils.LOGGER.warn("ultraeconomy", "Player locale string is null or empty, returning server locale");
            }
            return serverLocale;
        }
        return (Locale)localeCache.get((Object)localeStr, key -> {
            try {
                Locale playerLocale = Locale.forLanguageTag(localeStr.replace('_', '-'));
                if (UltraEconomy.config.isDebug()) {
                    CobbleUtils.LOGGER.info("ultraeconomy", "Player locale: " + String.valueOf(playerLocale));
                }
                return playerLocale;
            }
            catch (Exception e) {
                if (UltraEconomy.config.isDebug()) {
                    CobbleUtils.LOGGER.error("ultraeconomy", "Error parsing player locale: " + localeStr + ", returning server locale");
                    e.printStackTrace();
                }
                return serverLocale;
            }
        });
    }

    private static void runMessage(UUID playerUUID, Runnable runnable) {
        if (UltraEconomy.config.isQueueMessages()) {
            PlayerMessageQueueManager.enqueue(playerUUID, runnable);
        } else {
            runnable.run();
        }
    }

    public static boolean existsPlayerWithName(String target) {
        return DatabaseFactory.INSTANCE.existPlayerWithName(target);
    }
}

