/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.commands.admin;

import com.kingpixel.cobbleutils.Model.messages.HiperMessage;
import com.kingpixel.cobbleutils.command.suggests.CobbleUtilsSuggests;
import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.api.UltraEconomyApi;
import com.kingpixel.ultraeconomy.commands.Register;
import com.kingpixel.ultraeconomy.config.Currencies;
import com.kingpixel.ultraeconomy.config.Lang;
import com.kingpixel.ultraeconomy.exceptions.UnknownCurrencyException;
import com.kingpixel.ultraeconomy.models.Currency;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class BalanceCommand {
    private static final String KEY_CURRENCY = "currency";
    private static final String KEY_PLAYER = "player";

    public static void put(CommandDispatcher<class_2168> dispatcher, LiteralArgumentBuilder<class_2168> base) {
        base.then(BalanceCommand.get());
        dispatcher.register(BalanceCommand.get());
    }

    private static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"balance").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            BalanceCommand.run(player == null ? null : player.method_5667(), (CommandContext<class_2168>)context, Currencies.DEFAULT_CURRENCY.getId());
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)KEY_CURRENCY, (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            int size = Currencies.CURRENCY_IDS.length;
            for (int i = 0; i < size; ++i) {
                builder.suggest(Currencies.CURRENCY_IDS[i]);
            }
            return builder.buildFuture();
        }).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            BalanceCommand.run(player == null ? null : player.method_5667(), (CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)KEY_CURRENCY));
            return 1;
        })).then(CobbleUtilsSuggests.SUGGESTS_PLAYER_OFFLINE_AND_ONLINE.suggestPlayerName(KEY_PLAYER, List.of("ultraeconomy.admin.balance"), 0).executes(context -> {
            CompletableFuture.runAsync(() -> {
                String target = StringArgumentType.getString((CommandContext)context, (String)KEY_PLAYER);
                if (!UltraEconomyApi.existsPlayerWithName(target)) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7cPlayer not found"));
                    return;
                }
                String currencyId = StringArgumentType.getString((CommandContext)context, (String)KEY_CURRENCY);
                UUID targetUUID = CobbleUtilsSuggests.SUGGESTS_PLAYER_OFFLINE_AND_ONLINE.getPlayerUUIDWithName(target);
                BalanceCommand.run(targetUUID, (CommandContext<class_2168>)context, currencyId);
            }, UltraEconomy.ULTRA_ECONOMY_EXECUTOR).exceptionally(e -> {
                if (e instanceof UnknownCurrencyException) {
                    return null;
                }
                e.printStackTrace();
                return null;
            });
            return 1;
        })));
    }

    public static void run(UUID targetUUID, CommandContext<class_2168> context, String currencyId) {
        CompletableFuture.runAsync(() -> {
            class_2168 source = (class_2168)context.getSource();
            if (targetUUID == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cYou must be a player to use this command"));
                return;
            }
            Currency currency = Currencies.getCurrency(currencyId);
            BigDecimal balance = UltraEconomyApi.getBalance(targetUUID, currencyId);
            if (balance == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cBalance not found"));
                return;
            }
            class_3222 player = source.method_44023();
            Lang lang = UltraEconomy.lang;
            String modifiedContent = lang.getMessageBalance().getRawMessage().replace("%balance%", currency.format(balance, UltraEconomyApi.getLocale(player)));
            HiperMessage message = lang.getMessageBalance();
            message.sendMessage(player, modifiedContent, UltraEconomy.lang.getPrefix(), false);
        }, UltraEconomy.ULTRA_ECONOMY_EXECUTOR).exceptionally(e -> Register.sendFeedBack(e, context));
    }
}

