/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.commands.admin;

import com.kingpixel.cobbleutils.Model.DurationValue;
import com.kingpixel.cobbleutils.util.AdventureTranslator;
import com.kingpixel.cobbleutils.util.PlayerUtils;
import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.commands.Register;
import com.kingpixel.ultraeconomy.config.Currencies;
import com.kingpixel.ultraeconomy.database.DatabaseFactory;
import com.kingpixel.ultraeconomy.models.Account;
import com.kingpixel.ultraeconomy.models.Currency;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class BaltopCommand {
    private static final String CURRENCY_ARG = "currency";

    public static void put(CommandDispatcher<class_2168> dispatcher, LiteralArgumentBuilder<class_2168> base) {
        base.then(BaltopCommand.get());
        dispatcher.register(BaltopCommand.get());
        base.then(BaltopCommand.getBalTopMenu());
        dispatcher.register(BaltopCommand.getBalTopMenu());
    }

    private static LiteralArgumentBuilder<class_2168> getBalTopMenu() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"baltopmenu").then(class_2170.method_9244((String)CURRENCY_ARG, (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            int size = Currencies.CURRENCY_IDS.length;
            for (int i = 0; i < size; ++i) {
                builder.suggest(Currencies.CURRENCY_IDS[i]);
            }
            return builder.buildFuture();
        }).executes(context -> {
            String currencyId = StringArgumentType.getString((CommandContext)context, (String)CURRENCY_ARG);
            Currency currency = Currencies.getCurrency(currencyId);
            UltraEconomy.lang.getBalTopMenu().open(((class_2168)context.getSource()).method_44023(), 1, currency);
            return 1;
        }));
    }

    private static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"baltop").executes(context -> {
            BaltopCommand.run((CommandContext<class_2168>)context, Currencies.DEFAULT_CURRENCY.getId(), 1);
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CURRENCY_ARG, (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            int size = Currencies.CURRENCY_IDS.length;
            for (int i = 0; i < size; ++i) {
                builder.suggest(Currencies.CURRENCY_IDS[i]);
            }
            return builder.buildFuture();
        }).executes(context -> {
            BaltopCommand.run((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)CURRENCY_ARG), 1);
            return 1;
        })).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            BaltopCommand.run((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)CURRENCY_ARG), IntegerArgumentType.getInteger((CommandContext)context, (String)"page"));
            return 1;
        })));
    }

    public static void run(CommandContext<class_2168> context, String currencyId, int page) {
        class_2168 source = (class_2168)context.getSource();
        if (PlayerUtils.isCooldownMenu((class_3222)source.method_44023(), (String)"ultraeconomy.baltop", (DurationValue)UltraEconomy.config.getBalTopCooldown())) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            Currency currency = Currencies.getCurrency(currencyId);
            if (currency == null) {
                source.method_45068((class_2561)class_2561.method_43470((String)("\u00a7c Currency not found: " + currencyId)));
                return;
            }
            List<Account> topAccounts = DatabaseFactory.INSTANCE.getTopBalances(currency, page, UltraEconomy.config.getLimitTopPlayers());
            StringJoiner joiner = new StringJoiner("\n");
            joiner.add(UltraEconomy.lang.getMessageBalTopHeader().replace("%number%", String.valueOf(page == 0 ? 1 : page * UltraEconomy.config.getLimitTopPlayers())));
            if (topAccounts.isEmpty()) {
                joiner.add(UltraEconomy.lang.getMessageBalTopEmpty());
            } else {
                int limit = UltraEconomy.config.getLimitTopPlayers();
                int rank = (page - 1) * limit + 1;
                int size = topAccounts.size();
                if (size > limit) {
                    size = limit;
                }
                for (int i = 0; i < size; ++i) {
                    Account account = topAccounts.get(i);
                    String line = UltraEconomy.lang.getMessageBalTopLine().replace("%rank%", Integer.toString(rank)).replace("%player%", account.getPlayerName()).replace("%balance%", currency.format(account.getBalance(currency)));
                    joiner.add(line);
                    ++rank;
                }
            }
            int previousPage = Math.min(1, page - 1);
            int nextPage = page + 1;
            joiner.add(UltraEconomy.lang.getMessageBalTopFooter().replace("%page%", Integer.toString(page)).replace("%currency%", currency.getId()).replace("%previous_page%", Integer.toString(previousPage)).replace("%next_page%", Integer.toString(nextPage)));
            String output = joiner.toString();
            source.method_9226(() -> AdventureTranslator.toNative((String)output), false);
        }, UltraEconomy.ULTRA_ECONOMY_EXECUTOR).exceptionally(e -> Register.sendFeedBack(e, context));
    }
}

