/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.commands.admin;

import com.kingpixel.cobbleutils.api.PermissionApi;
import com.kingpixel.cobbleutils.command.suggests.CobbleUtilsSuggests;
import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.api.UltraEconomyApi;
import com.kingpixel.ultraeconomy.commands.Register;
import com.kingpixel.ultraeconomy.config.Currencies;
import com.kingpixel.ultraeconomy.models.Currency;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PayCommand {
    public static void put(CommandDispatcher<class_2168> dispatcher, LiteralArgumentBuilder<class_2168> base) {
        base.then(PayCommand.get());
        dispatcher.register(PayCommand.get());
    }

    private static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pay").requires(source -> PermissionApi.hasPermission((class_2168)source, (String)"ultraeconomy.command.pay", (int)2))).then(class_2170.method_9244((String)"currency", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            int size = Currencies.CURRENCY_IDS.length;
            for (int i = 0; i < size; ++i) {
                builder.suggest(Currencies.CURRENCY_IDS[i]);
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).then(CobbleUtilsSuggests.SUGGESTS_PLAYER_OFFLINE_AND_ONLINE.suggestPlayerName("player", List.of("ultraeconomy.command.pay"), 2).executes(context -> {
            class_3222 executor = ((class_2168)context.getSource()).method_44023();
            String target = StringArgumentType.getString((CommandContext)context, (String)"player");
            if (!UltraEconomyApi.existsPlayerWithName(target)) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7cPlayer not found"));
                return 0;
            }
            String currencyId = StringArgumentType.getString((CommandContext)context, (String)"currency");
            BigDecimal amount = BigDecimal.valueOf(FloatArgumentType.getFloat((CommandContext)context, (String)"amount"));
            PayCommand.run(executor, target, currencyId, amount, (CommandContext<class_2168>)context);
            return 1;
        }))));
    }

    private static void run(class_3222 executor, String target, String currencyId, BigDecimal amount, CommandContext<class_2168> context) {
        CompletableFuture.runAsync(() -> {
            Currency currency = Currencies.getCurrency(currencyId);
            UUID targetUUID = CobbleUtilsSuggests.SUGGESTS_PLAYER_OFFLINE_AND_ONLINE.getPlayerUUIDWithName(target);
            if (executor.method_5667().equals(targetUUID)) {
                UltraEconomy.lang.getMessagePayYourself().sendMessage(executor, UltraEconomy.lang.getPrefix(), false);
                return;
            }
            UltraEconomyApi.transfer(executor.method_5667(), targetUUID, currency.getId(), amount);
        }, UltraEconomy.ULTRA_ECONOMY_EXECUTOR).exceptionally(e -> Register.sendFeedBack(e, context));
    }
}

