/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.commands.admin;

import com.kingpixel.cobbleutils.api.PermissionApi;
import com.kingpixel.cobbleutils.command.suggests.CobbleUtilsSuggests;
import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.api.UltraEconomyApi;
import com.kingpixel.ultraeconomy.commands.Register;
import com.kingpixel.ultraeconomy.config.Currencies;
import com.kingpixel.ultraeconomy.models.Currency;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class WithdrawCommand {
    public static void put(LiteralArgumentBuilder<class_2168> base) {
        base.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"withdraw").requires(source -> PermissionApi.hasPermission((class_2168)source, (String)"ultraeconomy.admin.withdraw", (int)2))).then(class_2170.method_9244((String)"amount", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"currency", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            int size = Currencies.CURRENCY_IDS.length;
            for (int i = 0; i < size; ++i) {
                builder.suggest(Currencies.CURRENCY_IDS[i]);
            }
            return builder.buildFuture();
        }).then(CobbleUtilsSuggests.SUGGESTS_PLAYER_OFFLINE_AND_ONLINE.suggestPlayerName("player", List.of("ultraeconomy.admin.withdraw"), 2).executes(context -> {
            CompletableFuture.runAsync(() -> {
                String target = StringArgumentType.getString((CommandContext)context, (String)"player");
                if (!UltraEconomyApi.existsPlayerWithName(target)) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a7cPlayer not found"));
                    return;
                }
                Currency currency = Currencies.getCurrency(StringArgumentType.getString((CommandContext)context, (String)"currency"));
                String amountStr = StringArgumentType.getString((CommandContext)context, (String)"amount");
                UUID playerUUID = CobbleUtilsSuggests.SUGGESTS_PLAYER_OFFLINE_AND_ONLINE.getPlayerUUIDWithName(target);
                if (playerUUID != null) {
                    BigDecimal value = BigDecimal.valueOf(Double.parseDouble(amountStr));
                    UltraEconomyApi.withdraw(playerUUID, currency.getId(), value);
                    Register.sendMessage(currency, value, playerUUID, UltraEconomy.lang.getMessageWithdraw());
                } else {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cPlayer not found"));
                }
            }, UltraEconomy.ULTRA_ECONOMY_EXECUTOR).exceptionally(e -> Register.sendFeedBack(e, (CommandContext<class_2168>)context));
            return 1;
        })))));
    }
}

