/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.config;

import com.google.gson.Gson;
import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.DataBaseConfig;
import com.kingpixel.cobbleutils.Model.DataBaseType;
import com.kingpixel.cobbleutils.Model.DurationValue;
import com.kingpixel.cobbleutils.util.Utils;
import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.models.MigrationConfig;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class Config {
    private static final String FILE_NAME = "config.json";
    private boolean debug = false;
    private boolean notifications = true;
    private boolean queueMessages = false;
    private DurationValue betweenMessagesDelay = DurationValue.parse((String)"1s");
    private String lang = "en_us";
    private List<String> commands = List.of("money", "balance", "bal", "eco", "ultraeconomy");
    private DataBaseConfig database = new DataBaseConfig();
    private MigrationConfig migration;
    private int limitTopPlayers;
    private int adjustmentShortName;
    private DurationValue balTopCooldown;

    public Config() {
        this.database.setType(DataBaseType.SQLITE);
        this.database.setUrl("jdbc:sqlite:./config/ultraeconomy/ultraeconomy.db");
        this.migration = new MigrationConfig();
        this.limitTopPlayers = 10;
        this.adjustmentShortName = 3;
        this.balTopCooldown = DurationValue.parse((String)"10s");
    }

    public void init() {
        CompletableFuture futureRead = Utils.readFileAsync((String)"/config/ultraeconomy", (String)FILE_NAME, callback -> {
            Gson gson = Utils.newGson();
            UltraEconomy.config = (Config)gson.fromJson(callback, Config.class);
            String data = gson.toJson((Object)UltraEconomy.config);
            Utils.writeFileAsync((String)"/config/ultraeconomy", (String)FILE_NAME, (String)data);
        });
        if (Boolean.FALSE.equals(futureRead.join())) {
            CobbleUtils.LOGGER.info("Creating new config file at " + Utils.getAbsolutePath((String)"/config/ultraeconomy/config.json").getAbsolutePath());
            Gson gson = Utils.newGson();
            UltraEconomy.config = this;
            String data = gson.toJson((Object)UltraEconomy.config);
            Utils.writeFileAsync((String)"/config/ultraeconomy", (String)FILE_NAME, (String)data);
        }
    }

    public void writeConfig() {
        Gson gson = Utils.newGson();
        String data = gson.toJson((Object)this);
        Utils.writeFileAsync((String)"/config/ultraeconomy", (String)FILE_NAME, (String)data);
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public boolean isNotifications() {
        return this.notifications;
    }

    @Generated
    public boolean isQueueMessages() {
        return this.queueMessages;
    }

    @Generated
    public DurationValue getBetweenMessagesDelay() {
        return this.betweenMessagesDelay;
    }

    @Generated
    public String getLang() {
        return this.lang;
    }

    @Generated
    public List<String> getCommands() {
        return this.commands;
    }

    @Generated
    public DataBaseConfig getDatabase() {
        return this.database;
    }

    @Generated
    public MigrationConfig getMigration() {
        return this.migration;
    }

    @Generated
    public int getLimitTopPlayers() {
        return this.limitTopPlayers;
    }

    @Generated
    public int getAdjustmentShortName() {
        return this.adjustmentShortName;
    }

    @Generated
    public DurationValue getBalTopCooldown() {
        return this.balTopCooldown;
    }

    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Generated
    public void setNotifications(boolean notifications) {
        this.notifications = notifications;
    }

    @Generated
    public void setQueueMessages(boolean queueMessages) {
        this.queueMessages = queueMessages;
    }

    @Generated
    public void setBetweenMessagesDelay(DurationValue betweenMessagesDelay) {
        this.betweenMessagesDelay = betweenMessagesDelay;
    }

    @Generated
    public void setLang(String lang) {
        this.lang = lang;
    }

    @Generated
    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    @Generated
    public void setDatabase(DataBaseConfig database) {
        this.database = database;
    }

    @Generated
    public void setMigration(MigrationConfig migration) {
        this.migration = migration;
    }

    @Generated
    public void setLimitTopPlayers(int limitTopPlayers) {
        this.limitTopPlayers = limitTopPlayers;
    }

    @Generated
    public void setAdjustmentShortName(int adjustmentShortName) {
        this.adjustmentShortName = adjustmentShortName;
    }

    @Generated
    public void setBalTopCooldown(DurationValue balTopCooldown) {
        this.balTopCooldown = balTopCooldown;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isNotifications() != other.isNotifications()) {
            return false;
        }
        if (this.isQueueMessages() != other.isQueueMessages()) {
            return false;
        }
        if (this.getLimitTopPlayers() != other.getLimitTopPlayers()) {
            return false;
        }
        if (this.getAdjustmentShortName() != other.getAdjustmentShortName()) {
            return false;
        }
        DurationValue this$betweenMessagesDelay = this.getBetweenMessagesDelay();
        DurationValue other$betweenMessagesDelay = other.getBetweenMessagesDelay();
        if (this$betweenMessagesDelay == null ? other$betweenMessagesDelay != null : !this$betweenMessagesDelay.equals(other$betweenMessagesDelay)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        List<String> this$commands = this.getCommands();
        List<String> other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
            return false;
        }
        DataBaseConfig this$database = this.getDatabase();
        DataBaseConfig other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        MigrationConfig this$migration = this.getMigration();
        MigrationConfig other$migration = other.getMigration();
        if (this$migration == null ? other$migration != null : !((Object)this$migration).equals(other$migration)) {
            return false;
        }
        DurationValue this$balTopCooldown = this.getBalTopCooldown();
        DurationValue other$balTopCooldown = other.getBalTopCooldown();
        return !(this$balTopCooldown == null ? other$balTopCooldown != null : !this$balTopCooldown.equals(other$balTopCooldown));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isNotifications() ? 79 : 97);
        result = result * 59 + (this.isQueueMessages() ? 79 : 97);
        result = result * 59 + this.getLimitTopPlayers();
        result = result * 59 + this.getAdjustmentShortName();
        DurationValue $betweenMessagesDelay = this.getBetweenMessagesDelay();
        result = result * 59 + ($betweenMessagesDelay == null ? 43 : $betweenMessagesDelay.hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        List<String> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        DataBaseConfig $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        MigrationConfig $migration = this.getMigration();
        result = result * 59 + ($migration == null ? 43 : ((Object)$migration).hashCode());
        DurationValue $balTopCooldown = this.getBalTopCooldown();
        result = result * 59 + ($balTopCooldown == null ? 43 : $balTopCooldown.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Config(debug=" + this.isDebug() + ", notifications=" + this.isNotifications() + ", queueMessages=" + this.isQueueMessages() + ", betweenMessagesDelay=" + String.valueOf(this.getBetweenMessagesDelay()) + ", lang=" + this.getLang() + ", commands=" + String.valueOf(this.getCommands()) + ", database=" + String.valueOf(this.getDatabase()) + ", migration=" + String.valueOf(this.getMigration()) + ", limitTopPlayers=" + this.getLimitTopPlayers() + ", adjustmentShortName=" + this.getAdjustmentShortName() + ", balTopCooldown=" + String.valueOf(this.getBalTopCooldown()) + ")";
    }
}

