/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.config;

import com.kingpixel.cobbleutils.util.Utils;
import com.kingpixel.ultraeconomy.exceptions.UnknownCurrencyException;
import com.kingpixel.ultraeconomy.models.Currency;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Currencies {
    private static String PATH = "/config/ultraeconomy/currencys/";
    private static final Map<String, Currency> CURRENCY_MAP = new HashMap<String, Currency>();
    public static String[] CURRENCY_IDS;
    public static Currency DEFAULT_CURRENCY;

    public static void init() {
        CURRENCY_MAP.clear();
        File folder = Utils.getAbsolutePath((String)PATH);
        folder.mkdirs();
        List files = Utils.getFiles((File)folder);
        if (files.isEmpty()) {
            Currency currency = new Currency(true, 2, "$", new String[]{"impactor:dollars"});
            currency.setId("dollars");
            currency.fix();
            CURRENCY_MAP.put(currency.getId(), currency);
            Currencies.writeCurrency(currency);
            Currency currency2 = new Currency(false, 2, "t", new String[]{"impactor:tokens"});
            currency2.setId("tokens");
            CURRENCY_MAP.put(currency2.getId(), currency2);
            Currencies.writeCurrency(currency2);
        } else {
            for (Object file : files) {
                try {
                    Currency currency = (Currency)Utils.newGson().fromJson(Utils.readFileSync((File)file), Currency.class);
                    currency.fix();
                    currency.setId(((File)file).getName().replace(".json", ""));
                    CURRENCY_MAP.put(currency.getId(), currency);
                    Currencies.writeCurrency(currency);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        HashMap<String, Currency> aliases = new HashMap<String, Currency>();
        for (Currency currency : CURRENCY_MAP.values()) {
            if (currency.getCurrencyIds() == null) continue;
            for (String alias : currency.getCurrencyIds()) {
                aliases.put(alias, currency);
            }
        }
        CURRENCY_MAP.putAll(aliases);
        CURRENCY_MAP.forEach((k, v) -> {
            v.init();
            if (v.isPrimary()) {
                DEFAULT_CURRENCY = v;
            }
        });
        HashSet IdCurrency = new HashSet();
        CURRENCY_MAP.values().forEach(c -> IdCurrency.add(c.getId()));
        CURRENCY_IDS = new String[IdCurrency.size()];
        int i = 0;
        Iterator iterator = IdCurrency.iterator();
        while (iterator.hasNext()) {
            String id;
            Currencies.CURRENCY_IDS[i] = id = (String)iterator.next();
            ++i;
        }
    }

    public static Map<String, Currency> getCurrencyMap() {
        return CURRENCY_MAP;
    }

    private static void writeCurrency(Currency currency) {
        String data = Utils.newGson().toJson((Object)currency);
        Utils.writeFileAsync((String)PATH, (String)(currency.getId() + ".json"), (String)data);
    }

    public static Currency getCurrency(String currency) throws UnknownCurrencyException {
        Currency curr = CURRENCY_MAP.get(currency);
        if (curr == null) {
            curr = DEFAULT_CURRENCY;
        }
        if (curr == null) {
            throw new UnknownCurrencyException(currency);
        }
        return curr;
    }
}

