/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.database;

import com.kingpixel.cobbleutils.Model.DataBaseConfig;
import com.kingpixel.cobbleutils.command.suggests.CobbleUtilsSuggests;
import com.kingpixel.ultraeconomy.api.UltraEconomyApi;
import com.kingpixel.ultraeconomy.database.DatabaseFactory;
import com.kingpixel.ultraeconomy.models.Account;
import com.kingpixel.ultraeconomy.models.Currency;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public abstract class DatabaseClient {
    public abstract void connect(DataBaseConfig var1);

    public abstract void disconnect();

    public abstract void invalidate(UUID var1);

    public abstract boolean isConnected();

    public abstract Account getAccount(UUID var1);

    public abstract void saveOrUpdateAccount(Account var1);

    public abstract boolean addBalance(UUID var1, Currency var2, BigDecimal var3);

    public boolean deposit(UUID uuid, Currency currency, BigDecimal amount) {
        return this.addBalance(uuid, currency, amount);
    }

    public abstract boolean removeBalance(UUID var1, Currency var2, BigDecimal var3);

    public boolean withdraw(UUID uuid, Currency currency, BigDecimal amount) {
        return this.removeBalance(uuid, currency, amount);
    }

    @Nullable
    public abstract BigDecimal getBalance(UUID var1, Currency var2);

    public abstract BigDecimal setBalance(UUID var1, Currency var2, BigDecimal var3);

    public abstract boolean hasEnoughBalance(UUID var1, Currency var2, BigDecimal var3);

    public abstract List<Account> getTopBalances(Currency var1, int var2, int var3);

    public void flushCache() {
        DatabaseFactory.CACHE_ACCOUNTS.asMap().forEach((uuid, account) -> UltraEconomyApi.saveAccountSync(account));
    }

    public boolean existPlayerWithName(String target) {
        return this.existPlayerWithUUID(CobbleUtilsSuggests.SUGGESTS_PLAYER_OFFLINE_AND_ONLINE.getPlayerUUIDWithName(target));
    }

    public abstract boolean existPlayerWithUUID(UUID var1);

    public abstract void saveOrUpdateAccountSync(Account var1);
}

