/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.database;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.DataBaseConfig;
import com.kingpixel.cobbleutils.Model.DataBaseType;
import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.database.DatabaseClient;
import com.kingpixel.ultraeconomy.database.MongoDBClient;
import com.kingpixel.ultraeconomy.database.SQLClient;
import com.kingpixel.ultraeconomy.exceptions.DatabaseConnectionException;
import com.kingpixel.ultraeconomy.models.Account;
import java.util.Arrays;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class DatabaseFactory {
    public static final Cache<@NotNull UUID, Account> CACHE_ACCOUNTS = Caffeine.newBuilder().maximumSize(1000L).removalListener((key, value, cause) -> {
        if (cause.equals((Object)RemovalCause.REPLACED) || UltraEconomy.server.method_16043() || UltraEconomy.server.method_3750()) {
            return;
        }
        if (value != null) {
            Account account = (Account)value;
            CobbleUtils.LOGGER.info("Saving account " + String.valueOf(account.getPlayerUUID()) + " to database (cause: " + String.valueOf(cause) + ")");
            INSTANCE.saveOrUpdateAccount((Account)value);
        } else {
            CobbleUtils.LOGGER.warn("Tried to save null account to database (cause: " + String.valueOf(cause) + ")");
        }
    }).build();
    public static DatabaseClient INSTANCE;

    public static void init(DataBaseConfig config) {
        if (INSTANCE != null) {
            INSTANCE.disconnect();
        }
        switch (config.getType()) {
            case SQLITE: 
            case MYSQL: 
            case MARIADB: 
            case H2: {
                INSTANCE = new SQLClient();
                break;
            }
            case MONGODB: {
                INSTANCE = new MongoDBClient();
                break;
            }
            default: {
                throw new DatabaseConnectionException("Unknown database type " + Arrays.toString(DataBaseType.values()));
            }
        }
        INSTANCE.connect(config);
    }

    public static boolean isConnected() {
        return INSTANCE != null && INSTANCE.isConnected();
    }
}

