/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.database;

import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.DataBaseConfig;
import com.kingpixel.cobbleutils.util.Utils;
import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.database.DatabaseClient;
import com.kingpixel.ultraeconomy.database.DatabaseFactory;
import com.kingpixel.ultraeconomy.models.Account;
import com.kingpixel.ultraeconomy.models.Currency;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_3222;

public class JSONClient
extends DatabaseClient {
    private static final String PATH = "/config/ultraeconomy/accounts/";
    private static final String FILE_SUFFIX = ".json";

    @Override
    public void connect(DataBaseConfig config) {
        Utils.getAbsolutePath((String)PATH).mkdirs();
        CobbleUtils.LOGGER.info("Using JSON database at /config/ultraeconomy/accounts/");
    }

    @Override
    public void disconnect() {
        DatabaseFactory.CACHE_ACCOUNTS.invalidateAll();
        CobbleUtils.LOGGER.info("JSON database does not require disconnection.");
    }

    @Override
    public void invalidate(UUID playerUUID) {
        DatabaseFactory.CACHE_ACCOUNTS.invalidate((Object)playerUUID);
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public Account getAccount(UUID uuid) {
        Account account = (Account)DatabaseFactory.CACHE_ACCOUNTS.getIfPresent((Object)uuid);
        if (account != null) {
            return account;
        }
        File accountFile = Utils.getAbsolutePath((String)(PATH + uuid.toString() + FILE_SUFFIX));
        if (accountFile.exists()) {
            try {
                String data = Utils.readFileSync((File)accountFile);
                account = (Account)Utils.newWithoutSpacingGson().fromJson(data, Account.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            class_3222 player = CobbleUtils.server.method_3760().method_14602(uuid);
            if (player == null) {
                CobbleUtils.LOGGER.warn("Could not find player with UUID " + String.valueOf(uuid) + ", account creation failed.");
                return null;
            }
            CobbleUtils.LOGGER.info("Creating new account for " + player.method_5477().getString());
            account = new Account(player);
            this.saveOrUpdateAccount(account);
        }
        if (account == null) {
            CobbleUtils.LOGGER.warn("Could not load or create account for player with UUID " + String.valueOf(uuid));
            return null;
        }
        return account;
    }

    @Override
    public void saveOrUpdateAccount(Account account) {
        CompletableFuture.runAsync(() -> this.saveAccount(account), UltraEconomy.ULTRA_ECONOMY_EXECUTOR).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
    }

    @Override
    public void saveOrUpdateAccountSync(Account account) {
        this.saveAccount(account);
    }

    private void saveAccount(Account account) {
        String data = Utils.newWithoutSpacingGson().toJson((Object)account, Account.class);
        File accountFile = Utils.getAbsolutePath((String)(PATH + account.getPlayerUUID().toString() + FILE_SUFFIX));
        Utils.writeFileAsync((File)accountFile, (String)data);
    }

    @Override
    public boolean addBalance(UUID uuid, Currency currency, BigDecimal amount) {
        return this.getAccount(uuid).addBalance(currency, amount);
    }

    @Override
    public boolean removeBalance(UUID uuid, Currency currency, BigDecimal amount) {
        return this.getAccount(uuid).removeBalance(currency, amount);
    }

    @Override
    public BigDecimal getBalance(UUID uuid, Currency currency) {
        return this.getAccount(uuid).getBalance(currency);
    }

    @Override
    public BigDecimal setBalance(UUID uuid, Currency currency, BigDecimal amount) {
        return this.getAccount(uuid).setBalance(currency, amount);
    }

    @Override
    public boolean hasEnoughBalance(UUID uuid, Currency currency, BigDecimal amount) {
        return this.getAccount(uuid).hasEnoughBalance(currency, amount);
    }

    @Override
    public List<Account> getTopBalances(Currency currency, int page, int playersPerPage) {
        CobbleUtils.LOGGER.warn("getTopBalances is not supported in JSON database.");
        return List.of();
    }

    @Override
    public boolean existPlayerWithUUID(UUID uuid) {
        return Utils.getAbsolutePath((String)(PATH + uuid.toString() + FILE_SUFFIX)).exists();
    }
}

