/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.database;

import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.DataBaseConfig;
import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.api.UltraEconomyApi;
import com.kingpixel.ultraeconomy.config.Currencies;
import com.kingpixel.ultraeconomy.database.DatabaseClient;
import com.kingpixel.ultraeconomy.database.DatabaseFactory;
import com.kingpixel.ultraeconomy.database.TransactionType;
import com.kingpixel.ultraeconomy.models.Account;
import com.kingpixel.ultraeconomy.models.Currency;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.conversions.Bson;
import org.bson.types.Decimal128;

public class MongoDBClient
extends DatabaseClient {
    private static final String TRANSACTIONS_COLLECTION = "transactions";
    private static final String ACCOUNTS_COLLECTION = "accounts";
    public static final String FIELD_UUID = "uuid";
    public static final String FIELD_PLAYER_NAME = "player_name";
    public static final String FIELD_BALANCES = "balances";
    private static final String FIELD_ACCOUNT_UUID = "account_uuid";
    private static final String FIELD_CURRENCY_ID = "currency_id";
    private static final String FIELD_AMOUNT = "amount";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_PROCESSED = "processed";
    private MongoClient mongoClient;
    private MongoCollection<Document> accountsCollection;
    private MongoCollection<Document> transactionsCollection;
    private ScheduledExecutorService transactionExecutor;
    private boolean runningTransactions = false;

    @Override
    public void connect(DataBaseConfig config) {
        try {
            this.mongoClient = MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyConnectionString(new ConnectionString(config.getUrl())).uuidRepresentation(UuidRepresentation.STANDARD).applicationName("UltraEconomy-MongoDB").build());
            MongoDatabase database = this.mongoClient.getDatabase(config.getDatabase());
            this.accountsCollection = database.getCollection(ACCOUNTS_COLLECTION);
            this.transactionsCollection = database.getCollection(TRANSACTIONS_COLLECTION);
            this.ensureIndexes();
            this.transactionExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = new Thread(r, "Mongo-Transaction-Worker");
                t.setDaemon(true);
                return t;
            });
            this.runningTransactions = true;
            this.transactionExecutor.scheduleAtFixedRate(this::checkAndApplyTransactions, 0L, 2L, TimeUnit.SECONDS);
            CobbleUtils.LOGGER.info("Connected to MongoDB at " + config.getUrl());
        }
        catch (Exception e) {
            CobbleUtils.LOGGER.error("\u274c Could not connect to MongoDB: " + e.getMessage());
            this.mongoClient = null;
        }
    }

    private void ensureIndexes() {
        try {
            HashSet<String> existingIndexes = new HashSet<String>();
            for (Document index : this.accountsCollection.listIndexes()) {
                existingIndexes.add((String)index.get((Object)"name", String.class));
            }
            if (!existingIndexes.contains("uuid_1")) {
                this.accountsCollection.createIndex((Bson)new Document(FIELD_UUID, (Object)1));
            }
            existingIndexes.clear();
            for (Document index : this.transactionsCollection.listIndexes()) {
                existingIndexes.add((String)index.get((Object)"name", String.class));
            }
            if (!existingIndexes.contains("account_uuid_1")) {
                this.transactionsCollection.createIndex((Bson)new Document(FIELD_ACCOUNT_UUID, (Object)1));
            }
            if (!existingIndexes.contains("currency_id_1")) {
                this.transactionsCollection.createIndex((Bson)new Document(FIELD_CURRENCY_ID, (Object)1));
            }
            if (!existingIndexes.contains("processed_1")) {
                this.transactionsCollection.createIndex((Bson)new Document(FIELD_PROCESSED, (Object)1));
            }
            CobbleUtils.LOGGER.info("Indexes verified/created successfully.");
        }
        catch (Exception e) {
            CobbleUtils.LOGGER.error("Error ensuring MongoDB indexes: " + e.getMessage());
        }
    }

    @Override
    public void disconnect() {
        DatabaseFactory.CACHE_ACCOUNTS.invalidateAll();
        if (this.transactionExecutor != null) {
            this.runningTransactions = false;
            CobbleUtils.shutdownAndAwait((ExecutorService)this.transactionExecutor);
        }
        if (this.mongoClient != null) {
            this.mongoClient.close();
            CobbleUtils.LOGGER.info("Disconnected from MongoDB.");
        }
    }

    @Override
    public void invalidate(UUID playerUUID) {
        DatabaseFactory.CACHE_ACCOUNTS.invalidate((Object)playerUUID);
    }

    @Override
    public boolean isConnected() {
        return this.mongoClient != null;
    }

    @Override
    public Account getAccount(UUID uuid) {
        Account account;
        Account cached = (Account)DatabaseFactory.CACHE_ACCOUNTS.getIfPresent((Object)uuid);
        if (cached != null) {
            return cached;
        }
        Document doc = (Document)this.accountsCollection.find(Filters.eq((String)FIELD_UUID, (Object)uuid.toString())).first();
        if (doc != null) {
            account = Account.fromDocument(doc);
        } else {
            class_3222 player = CobbleUtils.server.method_3760().method_14602(uuid);
            if (player != null) {
                account = new Account(player);
                this.saveOrUpdateAccount(account);
            } else {
                CobbleUtils.LOGGER.warn("Could not find player with UUID " + String.valueOf(uuid));
                return null;
            }
        }
        return account;
    }

    @Override
    public void saveOrUpdateAccount(Account account) {
        CompletableFuture.runAsync(() -> this.saveAccount(account), UltraEconomy.ULTRA_ECONOMY_EXECUTOR).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
    }

    @Override
    public void saveOrUpdateAccountSync(Account account) {
        this.saveAccount(account);
    }

    private void saveAccount(Account account) {
        Document accountDoc = account.toDocument();
        this.accountsCollection.replaceOne(Filters.eq((String)FIELD_UUID, (Object)account.getPlayerUUID().toString()), (Object)accountDoc, new ReplaceOptions().upsert(true));
    }

    private void addTransaction(UUID uuid, Currency currency, BigDecimal amount, TransactionType type, boolean processed) {
        CompletableFuture.runAsync(() -> {
            Document tx = new Document(FIELD_ACCOUNT_UUID, (Object)uuid.toString()).append(FIELD_CURRENCY_ID, (Object)currency.getId()).append(FIELD_AMOUNT, (Object)new Decimal128(amount)).append(FIELD_TYPE, (Object)type.name()).append(FIELD_PROCESSED, (Object)processed).append("timestamp", (Object)Date.from(Instant.now()));
            this.transactionsCollection.insertOne((Object)tx);
        }, UltraEconomy.ULTRA_ECONOMY_EXECUTOR).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
    }

    private void checkAndApplyTransactions() {
        if (!this.runningTransactions || UltraEconomy.server == null) {
            return;
        }
        List players = UltraEconomy.server.method_3760().method_14571();
        List<String> uuids = players.stream().map(class_1297::method_5845).toList();
        if (uuids.isEmpty()) {
            return;
        }
        try {
            Document tx;
            block17: while ((tx = (Document)this.transactionsCollection.findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)FIELD_PROCESSED, (Object)false), Filters.in((String)FIELD_ACCOUNT_UUID, uuids)}), Updates.set((String)FIELD_PROCESSED, (Object)true))) != null) {
                TransactionType type;
                BigDecimal amount;
                Object object;
                UUID uuid = UUID.fromString(tx.getString((Object)FIELD_ACCOUNT_UUID));
                Account account = this.getCachedAccount(uuid);
                if (account == null) {
                    if (UltraEconomy.config.isDebug()) {
                        CobbleUtils.LOGGER.warn("Account not found in cache for transaction: " + tx.toJson());
                    }
                    this.transactionsCollection.updateOne(Filters.eq((String)"_id", (Object)tx.getObjectId((Object)"_id")), Updates.set((String)FIELD_PROCESSED, (Object)false));
                    continue;
                }
                String currencyId = tx.getString((Object)FIELD_CURRENCY_ID);
                Currency currency = Currencies.getCurrency(currencyId);
                Object rawAmount = tx.get((Object)FIELD_AMOUNT);
                Objects.requireNonNull(rawAmount);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Decimal128.class, Integer.class, Long.class, Double.class, Float.class}, (Object)object, n)) {
                    case 0: {
                        String s = (String)object;
                        amount = new BigDecimal(s);
                        break;
                    }
                    case 1: {
                        Decimal128 d = (Decimal128)object;
                        amount = d.bigDecimalValue();
                        break;
                    }
                    case 2: {
                        Integer i = (Integer)object;
                        amount = BigDecimal.valueOf(i.intValue());
                        break;
                    }
                    case 3: {
                        Long l = (Long)object;
                        amount = BigDecimal.valueOf(l);
                        break;
                    }
                    case 4: {
                        Double d = (Double)object;
                        amount = BigDecimal.valueOf(d);
                        break;
                    }
                    case 5: {
                        Float f = (Float)object;
                        amount = BigDecimal.valueOf(f.floatValue());
                        break;
                    }
                    default: {
                        CobbleUtils.LOGGER.error("Unknown amount type in transaction: " + tx.toJson());
                        continue block17;
                    }
                }
                try {
                    type = TransactionType.valueOf(tx.getString((Object)FIELD_TYPE));
                }
                catch (IllegalArgumentException ex) {
                    CobbleUtils.LOGGER.error("Invalid transaction type: " + tx.toJson());
                    ex.printStackTrace();
                    continue;
                }
                switch (type) {
                    case DEPOSIT: {
                        UltraEconomyApi.deposit(uuid, currency.getId(), amount);
                        break;
                    }
                    case WITHDRAW: {
                        UltraEconomyApi.withdraw(uuid, currency.getId(), amount);
                        break;
                    }
                    case SET: {
                        UltraEconomyApi.setBalance(uuid, currency.getId(), amount);
                        break;
                    }
                    default: {
                        CobbleUtils.LOGGER.error("Unknown transaction type: " + String.valueOf((Object)type));
                        continue block17;
                    }
                }
                this.saveOrUpdateAccount(account);
                DatabaseFactory.CACHE_ACCOUNTS.put((Object)uuid, (Object)account);
                if (!CobbleUtils.config.isDebug()) continue;
                CobbleUtils.LOGGER.info("Processed transaction: " + tx.toJson());
            }
        }
        catch (Exception e) {
            CobbleUtils.LOGGER.error("Error processing transactions");
            e.printStackTrace();
        }
    }

    @Override
    public boolean addBalance(UUID uuid, Currency currency, BigDecimal amount) {
        Account account = this.getCachedAccount(uuid);
        boolean result = true;
        if (account == null) {
            if (UltraEconomy.config.isDebug()) {
                CobbleUtils.LOGGER.warn("ultraeconomy", "Account not found in cache for UUID: " + String.valueOf(uuid) + ", queuing transaction.");
            }
            this.addTransaction(uuid, currency, amount, TransactionType.DEPOSIT, false);
        } else {
            if (UltraEconomy.config.isDebug()) {
                CobbleUtils.LOGGER.info("ultraeconomy", "Account found in cache for UUID: " + String.valueOf(uuid) + ", adding balance.");
            }
            if (result = account.addBalance(currency, amount)) {
                this.addTransaction(uuid, currency, amount, TransactionType.DEPOSIT, true);
            }
        }
        return result;
    }

    @Override
    public boolean removeBalance(UUID uuid, Currency currency, BigDecimal amount) {
        Account account = this.getCachedAccount(uuid);
        boolean result = true;
        if (account == null) {
            if (UltraEconomy.config.isDebug()) {
                CobbleUtils.LOGGER.warn("ultraeconomy", "Account not found in cache for UUID: " + String.valueOf(uuid) + ", queuing transaction.");
            }
            this.addTransaction(uuid, currency, amount, TransactionType.WITHDRAW, false);
        } else {
            if (UltraEconomy.config.isDebug()) {
                CobbleUtils.LOGGER.info("ultraeconomy", "Account found in cache for UUID: " + String.valueOf(uuid) + ", removing balance.");
            }
            result = account.removeBalance(currency, amount);
            this.addTransaction(uuid, currency, amount, TransactionType.WITHDRAW, true);
        }
        return result;
    }

    @Override
    public BigDecimal setBalance(UUID uuid, Currency currency, BigDecimal amount) {
        Account account = this.getCachedAccount(uuid);
        if (account == null) {
            if (UltraEconomy.config.isDebug()) {
                CobbleUtils.LOGGER.warn("ultraeconomy", "Account not found in cache for UUID: " + String.valueOf(uuid) + ", queuing transaction.");
            }
            this.addTransaction(uuid, currency, amount, TransactionType.SET, false);
        } else {
            if (UltraEconomy.config.isDebug()) {
                CobbleUtils.LOGGER.info("ultraeconomy", "Account found in cache for UUID: " + String.valueOf(uuid) + ", setting balance.");
            }
            account.setBalance(currency, amount);
            this.addTransaction(uuid, currency, amount, TransactionType.SET, true);
        }
        Bson filter = Filters.eq((String)FIELD_UUID, (Object)uuid.toString());
        Bson update = Updates.set((String)("balances." + currency.getId()), (Object)new Decimal128(amount));
        this.accountsCollection.updateOne(filter, update);
        return amount;
    }

    @Override
    public BigDecimal getBalance(UUID uuid, Currency currency) {
        return this.getAccount(uuid).getBalance(currency);
    }

    @Override
    public boolean hasEnoughBalance(UUID uuid, Currency currency, BigDecimal amount) {
        return this.getAccount(uuid).hasEnoughBalance(currency, amount);
    }

    @Override
    public List<Account> getTopBalances(Currency currency, int page, int playersPerPage) {
        ArrayList<Account> topAccounts = new ArrayList<Account>();
        int skip = Math.max(page - 1, 0) * playersPerPage;
        int index = skip + 1;
        String currencyKey = currency.getId();
        FindIterable docs = this.accountsCollection.find(Filters.exists((String)("balances." + currencyKey), (boolean)true)).sort(Sorts.descending((String[])new String[]{"balances." + currencyKey})).skip(skip).limit(playersPerPage + 1);
        for (Document doc : docs) {
            Account account = Account.fromDocument(doc);
            account.setRank(index++);
            topAccounts.add(account);
        }
        return topAccounts;
    }

    @Override
    public boolean existPlayerWithUUID(UUID uuid) {
        Document doc = (Document)this.accountsCollection.find(Filters.eq((String)FIELD_UUID, (Object)uuid.toString())).first();
        return doc != null;
    }

    public Account getCachedAccount(UUID uuid) {
        return (Account)DatabaseFactory.CACHE_ACCOUNTS.getIfPresent((Object)uuid);
    }
}

