/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.database;

import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.DataBaseConfig;
import com.kingpixel.cobbleutils.Model.DataBaseType;
import com.kingpixel.ultraeconomy.api.UltraEconomyApi;
import com.kingpixel.ultraeconomy.config.Currencies;
import com.kingpixel.ultraeconomy.database.DatabaseClient;
import com.kingpixel.ultraeconomy.database.DatabaseFactory;
import com.kingpixel.ultraeconomy.database.SQLSentences;
import com.kingpixel.ultraeconomy.database.TransactionType;
import com.kingpixel.ultraeconomy.exceptions.DatabaseConnectionException;
import com.kingpixel.ultraeconomy.exceptions.UnknownAccountException;
import com.kingpixel.ultraeconomy.models.Account;
import com.kingpixel.ultraeconomy.models.Currency;
import com.zaxxer.hikari.HikariDataSource;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.class_3222;

public class SQLClient
extends DatabaseClient {
    private static final String KEY_AMOUNT = "amount";
    private DataBaseType dbType;
    private HikariDataSource dataSource;
    private ScheduledExecutorService transactionExecutor;
    private ExecutorService asyncExecutor;
    private boolean runningTransactions = false;

    @Override
    public void connect(DataBaseConfig config) {
        try {
            this.dbType = config.getType();
            SQLSentences.Data data = SQLSentences.configure();
            this.asyncExecutor = data.getService();
            this.dataSource = data.getDataSource();
            CobbleUtils.LOGGER.info("Connected to " + String.valueOf(config.getType()) + " database at " + config.getUrl());
            this.initTables(config.getType());
            this.createIndexes();
            this.transactionExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = new Thread(r, "Transaction-Worker-UltraEconomy");
                t.setDaemon(true);
                return t;
            });
            this.runningTransactions = true;
            this.transactionExecutor.scheduleAtFixedRate(this::checkAndApplyTransactions, 0L, 2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new DatabaseConnectionException(config.getType().name());
        }
    }

    @Override
    public void disconnect() {
        this.runningTransactions = false;
        if (this.transactionExecutor != null) {
            CobbleUtils.shutdownAndAwait((ExecutorService)this.transactionExecutor);
        }
        if (this.asyncExecutor != null) {
            CobbleUtils.shutdownAndAwait((ExecutorService)this.asyncExecutor);
        }
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
        CobbleUtils.LOGGER.info("Disconnected from database.");
    }

    @Override
    public void invalidate(UUID playerUUID) {
        DatabaseFactory.CACHE_ACCOUNTS.invalidate((Object)playerUUID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Account getAccount(UUID uuid) {
        Account cached = (Account)DatabaseFactory.CACHE_ACCOUNTS.getIfPresent((Object)uuid);
        if (cached != null) {
            return cached;
        }
        try (Connection conn = this.dataSource.getConnection();){
            Account account;
            block26: {
                try (PreparedStatement stmt = conn.prepareStatement(SQLSentences.selectAccountByUUID());){
                    stmt.setString(1, uuid.toString());
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        HashMap<String, BigDecimal> balances = new HashMap<String, BigDecimal>();
                        try (PreparedStatement balStmt = conn.prepareStatement(SQLSentences.selectBalancesByUUID());){
                            balStmt.setString(1, uuid.toString());
                            ResultSet balRs = balStmt.executeQuery();
                            while (balRs.next()) {
                                balances.put(balRs.getString("currency_id"), balRs.getBigDecimal(KEY_AMOUNT));
                            }
                        }
                        account = new Account(uuid, rs.getString("player_name"), balances);
                        break block26;
                    }
                    class_3222 player = CobbleUtils.server.method_3760().method_14602(uuid);
                    if (player != null) {
                        account = new Account(player);
                        this.saveOrUpdateAccount(account);
                        break block26;
                    }
                    Account account2 = null;
                    return account2;
                }
            }
            DatabaseFactory.CACHE_ACCOUNTS.put((Object)uuid, (Object)account);
            Account account3 = account;
            return account3;
        }
        catch (SQLException e) {
            throw new UnknownAccountException(uuid);
        }
    }

    public void getAccountAsync(UUID uuid, Consumer<Account> callback) {
        this.asyncExecutor.submit(() -> callback.accept(this.getAccount(uuid)));
    }

    @Override
    public void saveOrUpdateAccount(Account account) {
        this.asyncExecutor.submit(() -> this.saveAccount(account));
    }

    @Override
    public void saveOrUpdateAccountSync(Account account) {
        this.saveAccount(account);
    }

    private void saveAccount(Account account) {
        try (Connection conn = this.dataSource.getConnection();){
            conn.setAutoCommit(false);
            try (PreparedStatement stmt = conn.prepareStatement(SQLSentences.insertAccount());){
                stmt.setString(1, account.getPlayerUUID().toString());
                stmt.setString(2, account.getPlayerName());
                stmt.executeUpdate();
            }
            for (Map.Entry<String, BigDecimal> entry : account.getBalances().entrySet()) {
                PreparedStatement balStmt = conn.prepareStatement(SQLSentences.insertBalance());
                try {
                    balStmt.setString(1, account.getPlayerUUID().toString());
                    balStmt.setString(2, entry.getKey());
                    balStmt.setBigDecimal(3, entry.getValue());
                    balStmt.executeUpdate();
                }
                finally {
                    if (balStmt == null) continue;
                    balStmt.close();
                }
            }
            conn.commit();
        }
        catch (SQLException e) {
            CobbleUtils.LOGGER.error("Error saving account " + String.valueOf(account.getPlayerUUID()));
            e.printStackTrace();
        }
    }

    @Override
    public boolean addBalance(UUID uuid, Currency currency, BigDecimal amount) {
        Account account = this.getCachedAccount(uuid);
        boolean result = false;
        if (account == null) {
            this.addTransaction(uuid, currency, amount, TransactionType.DEPOSIT, false);
        } else {
            result = account.addBalance(currency, amount);
            if (result) {
                this.addTransaction(uuid, currency, amount, TransactionType.DEPOSIT, true);
            }
        }
        return result;
    }

    @Override
    public boolean removeBalance(UUID uuid, Currency currency, BigDecimal amount) {
        Account account = this.getCachedAccount(uuid);
        boolean result = false;
        if (account == null) {
            this.addTransaction(uuid, currency, amount, TransactionType.WITHDRAW, false);
        } else {
            result = account.removeBalance(currency, amount);
            if (result) {
                this.addTransaction(uuid, currency, amount, TransactionType.WITHDRAW, true);
            }
        }
        return result;
    }

    @Override
    public BigDecimal setBalance(UUID uuid, Currency currency, BigDecimal amount) {
        Account account = this.getCachedAccount(uuid);
        if (account == null) {
            this.addTransaction(uuid, currency, amount, TransactionType.SET, false);
        } else {
            account.setBalance(currency, amount);
            this.addTransaction(uuid, currency, amount, TransactionType.SET, true);
            this.saveBalanceSafe(uuid, currency, amount);
        }
        return amount;
    }

    private void saveBalanceSafe(UUID uuid, Currency currency, BigDecimal amount) {
        this.asyncExecutor.submit(() -> {
            try {
                this.saveBalance(uuid, currency, amount);
                DatabaseFactory.CACHE_ACCOUNTS.invalidate((Object)uuid);
            }
            catch (SQLException e) {
                CobbleUtils.LOGGER.error("Error saving balance for " + String.valueOf(uuid));
                e.printStackTrace();
            }
        });
    }

    @Override
    public BigDecimal getBalance(UUID uuid, Currency currency) {
        return this.getAccount(uuid).getBalance(currency);
    }

    @Override
    public boolean hasEnoughBalance(UUID uuid, Currency currency, BigDecimal amount) {
        return this.getAccount(uuid).hasEnoughBalance(currency, amount);
    }

    @Override
    public List<Account> getTopBalances(Currency currency, int page, int playersPerPage) {
        ArrayList<Account> topAccounts = new ArrayList<Account>();
        int offset = (page - 1) * playersPerPage;
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(SQLSentences.selectTopBalances());){
            stmt.setString(1, currency.getId());
            stmt.setInt(2, playersPerPage);
            stmt.setInt(3, offset);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                String playerName = rs.getString("player_name");
                BigDecimal amount = rs.getBigDecimal(KEY_AMOUNT);
                HashMap<String, BigDecimal> balances = new HashMap<String, BigDecimal>();
                balances.put(currency.getId(), amount);
                Account account = new Account(uuid, playerName, balances);
                topAccounts.add(account);
            }
        }
        catch (SQLException e) {
            CobbleUtils.LOGGER.error("Error fetching top balances");
            e.printStackTrace();
        }
        return topAccounts;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean existPlayerWithUUID(UUID uuid) {
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(SQLSentences.selectAccountByUUID());
                try {
                    stmt.setString(1, uuid.toString());
                    ResultSet rs = stmt.executeQuery();
                    bl = rs.next();
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            CobbleUtils.LOGGER.error("Error checking existence of player with UUID " + String.valueOf(uuid));
            e.printStackTrace();
            return false;
        }
    }

    private void addTransaction(UUID uuid, Currency currency, BigDecimal amount, TransactionType type, boolean processed) {
        this.asyncExecutor.submit(() -> {
            String query = SQLSentences.insertTransaction();
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(query);){
                stmt.setString(1, uuid.toString());
                stmt.setString(2, currency.getId());
                stmt.setBigDecimal(3, amount);
                stmt.setString(4, type.name());
                stmt.setBoolean(5, processed);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                CobbleUtils.LOGGER.error("Error adding transaction for " + String.valueOf(uuid));
                e.printStackTrace();
            }
        });
    }

    private void checkAndApplyTransactions() {
        if (!this.runningTransactions) {
            return;
        }
        this.asyncExecutor.submit(() -> {
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(SQLSentences.selectPendingTransactions());){
                ResultSet rs = stmt.executeQuery();
                block22: while (rs.next()) {
                    UUID uuid = UUID.fromString(rs.getString("account_uuid"));
                    Account account = (Account)DatabaseFactory.CACHE_ACCOUNTS.getIfPresent((Object)uuid);
                    if (account == null) continue;
                    long id = rs.getLong("id");
                    String currencyId = rs.getString("currency_id");
                    Currency currency = Currencies.getCurrency(currencyId);
                    BigDecimal amount = rs.getBigDecimal(KEY_AMOUNT);
                    TransactionType type = rs.getString("type") != null ? TransactionType.valueOf(rs.getString("type")) : TransactionType.DEPOSIT;
                    switch (type) {
                        case DEPOSIT: {
                            UltraEconomyApi.deposit(uuid, currency.getId(), amount);
                            break;
                        }
                        case WITHDRAW: {
                            UltraEconomyApi.withdraw(uuid, currency.getId(), amount);
                            break;
                        }
                        case SET: {
                            UltraEconomyApi.setBalance(uuid, currency.getId(), amount);
                            break;
                        }
                        default: {
                            CobbleUtils.LOGGER.warn("Unknown transaction type for transaction ID " + id);
                            continue block22;
                        }
                    }
                    this.saveBalanceSafe(uuid, currency, account.getBalance(currency));
                    try (PreparedStatement update = conn.prepareStatement(SQLSentences.markTransactionProcessed());){
                        update.setLong(1, id);
                        update.executeUpdate();
                    }
                    DatabaseFactory.CACHE_ACCOUNTS.put((Object)uuid, (Object)account);
                }
            }
            catch (SQLException e) {
                CobbleUtils.LOGGER.error("Error processing transactions");
                e.printStackTrace();
            }
        });
    }

    private void initTables(DataBaseType type) throws SQLException {
        try (Connection conn = this.dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            String accountTable = switch (type) {
                case DataBaseType.SQLITE -> "CREATE TABLE IF NOT EXISTS accounts (\n    uuid TEXT PRIMARY KEY,\n    player_name TEXT NOT NULL\n)\n";
                case DataBaseType.MYSQL, DataBaseType.MARIADB, DataBaseType.H2 -> "CREATE TABLE IF NOT EXISTS accounts (\n    uuid VARCHAR(36) PRIMARY KEY,\n    player_name VARCHAR(64) NOT NULL\n)\n";
                default -> throw new IllegalArgumentException("Unsupported database type for table creation: " + String.valueOf(type));
            };
            stmt.executeUpdate(accountTable);
            String balanceTable = switch (type) {
                case DataBaseType.SQLITE -> "CREATE TABLE IF NOT EXISTS balances (\n    account_uuid TEXT NOT NULL,\n    currency_id TEXT NOT NULL,\n    amount TEXT NOT NULL,\n    PRIMARY KEY(account_uuid, currency_id),\n    FOREIGN KEY(account_uuid) REFERENCES accounts(uuid) ON DELETE CASCADE\n)\n";
                case DataBaseType.MYSQL, DataBaseType.MARIADB, DataBaseType.H2 -> "CREATE TABLE IF NOT EXISTS balances (\n    account_uuid VARCHAR(36) NOT NULL,\n    currency_id VARCHAR(64) NOT NULL,\n    amount DECIMAL(36,18) NOT NULL,\n    PRIMARY KEY(account_uuid, currency_id),\n    FOREIGN KEY(account_uuid) REFERENCES accounts(uuid) ON DELETE CASCADE\n)\n";
                default -> throw new IllegalArgumentException("Unsupported database type for table creation: " + String.valueOf(type));
            };
            stmt.executeUpdate(balanceTable);
            String transactionTable = switch (type) {
                case DataBaseType.SQLITE -> "CREATE TABLE IF NOT EXISTS transactions (\n    id INTEGER PRIMARY KEY AUTOINCREMENT,\n    account_uuid TEXT NOT NULL,\n    currency_id TEXT NOT NULL,\n    amount TEXT NOT NULL,\n    type TEXT NOT NULL,\n    timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,\n    processed INTEGER DEFAULT 0,\n    FOREIGN KEY(account_uuid) REFERENCES accounts(uuid) ON DELETE CASCADE\n)\n";
                case DataBaseType.MYSQL, DataBaseType.MARIADB, DataBaseType.H2 -> "CREATE TABLE IF NOT EXISTS transactions (\n    id BIGINT AUTO_INCREMENT PRIMARY KEY,\n    account_uuid VARCHAR(36) NOT NULL,\n    currency_id VARCHAR(64) NOT NULL,\n    amount DECIMAL(36,18) NOT NULL,\n    type VARCHAR(10) NOT NULL,\n    timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    processed BOOLEAN DEFAULT FALSE,\n    FOREIGN KEY(account_uuid) REFERENCES accounts(uuid) ON DELETE CASCADE\n)\n";
                default -> throw new IllegalArgumentException("Unsupported database type for table creation: " + String.valueOf(type));
            };
            stmt.executeUpdate(transactionTable);
        }
    }

    private void createIndexes() {
        this.asyncExecutor.submit(() -> {
            try (Connection conn = this.dataSource.getConnection();
                 Statement stmt = conn.createStatement();){
                stmt.executeUpdate("CREATE INDEX if NOT EXISTS idx_balances_currency_amount ON balances(currency_id, amount DESC)");
                stmt.executeUpdate("CREATE INDEX if NOT EXISTS idx_transactions_account_processed ON transactions(account_uuid, processed)");
                stmt.executeUpdate("CREATE INDEX if NOT EXISTS idx_transactions_account_currency ON transactions(account_uuid, currency_id)");
                stmt.executeUpdate("CREATE INDEX if NOT EXISTS idx_transactions_type_account ON transactions(\"type\", account_uuid)");
                stmt.executeUpdate("CREATE INDEX if NOT EXISTS idx_transactions_timestamp ON transactions(\"timestamp\")");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    private void saveBalance(UUID uuid, Currency currency, BigDecimal amount) throws SQLException {
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(SQLSentences.insertBalance());){
            stmt.setString(1, uuid.toString());
            stmt.setString(2, currency.getId());
            stmt.setBigDecimal(3, amount);
            stmt.executeUpdate();
        }
    }

    public Account getCachedAccount(UUID uuid) {
        return (Account)DatabaseFactory.CACHE_ACCOUNTS.getIfPresent((Object)uuid);
    }

    @Override
    public boolean isConnected() {
        boolean bl;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                boolean bl2 = bl = conn != null && !conn.isClosed();
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLClient)) {
            return false;
        }
        SQLClient other = (SQLClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isRunningTransactions() != other.isRunningTransactions()) {
            return false;
        }
        DataBaseType this$dbType = this.getDbType();
        DataBaseType other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        HikariDataSource this$dataSource = this.getDataSource();
        HikariDataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        ScheduledExecutorService this$transactionExecutor = this.getTransactionExecutor();
        ScheduledExecutorService other$transactionExecutor = other.getTransactionExecutor();
        if (this$transactionExecutor == null ? other$transactionExecutor != null : !this$transactionExecutor.equals(other$transactionExecutor)) {
            return false;
        }
        ExecutorService this$asyncExecutor = this.getAsyncExecutor();
        ExecutorService other$asyncExecutor = other.getAsyncExecutor();
        return !(this$asyncExecutor == null ? other$asyncExecutor != null : !this$asyncExecutor.equals(other$asyncExecutor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SQLClient;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRunningTransactions() ? 79 : 97);
        DataBaseType $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : $dbType.hashCode());
        HikariDataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        ScheduledExecutorService $transactionExecutor = this.getTransactionExecutor();
        result = result * 59 + ($transactionExecutor == null ? 43 : $transactionExecutor.hashCode());
        ExecutorService $asyncExecutor = this.getAsyncExecutor();
        result = result * 59 + ($asyncExecutor == null ? 43 : $asyncExecutor.hashCode());
        return result;
    }

    @Generated
    public SQLClient() {
    }

    @Generated
    public DataBaseType getDbType() {
        return this.dbType;
    }

    @Generated
    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public ScheduledExecutorService getTransactionExecutor() {
        return this.transactionExecutor;
    }

    @Generated
    public ExecutorService getAsyncExecutor() {
        return this.asyncExecutor;
    }

    @Generated
    public boolean isRunningTransactions() {
        return this.runningTransactions;
    }

    @Generated
    public void setDbType(DataBaseType dbType) {
        this.dbType = dbType;
    }

    @Generated
    public void setDataSource(HikariDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Generated
    public void setTransactionExecutor(ScheduledExecutorService transactionExecutor) {
        this.transactionExecutor = transactionExecutor;
    }

    @Generated
    public void setAsyncExecutor(ExecutorService asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    @Generated
    public void setRunningTransactions(boolean runningTransactions) {
        this.runningTransactions = runningTransactions;
    }

    @Generated
    public String toString() {
        return "SQLClient(dbType=" + String.valueOf(this.getDbType()) + ", dataSource=" + String.valueOf(this.getDataSource()) + ", transactionExecutor=" + String.valueOf(this.getTransactionExecutor()) + ", asyncExecutor=" + String.valueOf(this.getAsyncExecutor()) + ", runningTransactions=" + this.isRunningTransactions() + ")";
    }
}

