/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.database;

import com.kingpixel.cobbleutils.Model.DataBaseConfig;
import com.kingpixel.cobbleutils.Model.DataBaseType;
import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.database.DatabaseFactory;
import com.kingpixel.ultraeconomy.database.SQLClient;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;

public class SQLSentences {
    private static DataBaseType getType() {
        return ((SQLClient)DatabaseFactory.INSTANCE).getDbType();
    }

    public static Data configure() throws ClassNotFoundException {
        HikariDataSource dataSource;
        HikariConfig hikariConfig = new HikariConfig();
        DataBaseConfig config = UltraEconomy.config.getDatabase();
        return new Data(switch (SQLSentences.getType()) {
            case DataBaseType.SQLITE -> {
                Class.forName("org.sqlite.JDBC");
                hikariConfig.setJdbcUrl("jdbc:sqlite:config/ultraeconomy/database.db");
                hikariConfig.setMaximumPoolSize(1);
                hikariConfig.setMinimumIdle(1);
                hikariConfig.addDataSourceProperty("journal_mode", (Object)"WAL");
                dataSource = new HikariDataSource(hikariConfig);
                yield Executors.newSingleThreadExecutor(r -> {
                    Thread t = new Thread(r, "SQLite-Worker");
                    t.setDaemon(true);
                    return t;
                });
            }
            case DataBaseType.MYSQL, DataBaseType.MARIADB -> {
                Class.forName("com.mysql.cj.jdbc.Driver");
                hikariConfig.setJdbcUrl(config.getUrl());
                hikariConfig.setUsername(config.getUser());
                hikariConfig.setPassword(config.getPassword());
                hikariConfig.setMaximumPoolSize(10);
                hikariConfig.setMinimumIdle(5);
                hikariConfig.setAutoCommit(true);
                hikariConfig.addDataSourceProperty("cachePrepStmts", (Object)"true");
                hikariConfig.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
                hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
                hikariConfig.addDataSourceProperty("useServerPrepStmts", (Object)"true");
                dataSource = new HikariDataSource(hikariConfig);
                yield Executors.newFixedThreadPool(4, r -> {
                    Thread t = new Thread(r, "MySQL-Worker-UltraEconomy-%d");
                    t.setDaemon(true);
                    return t;
                });
            }
            case DataBaseType.H2 -> {
                Class.forName("org.h2.Driver");
                hikariConfig.setJdbcUrl("jdbc:h2:./config/ultraeconomy/database;MODE=MySQL;DATABASE_TO_UPPER=false");
                hikariConfig.setMaximumPoolSize(5);
                hikariConfig.setMinimumIdle(1);
                dataSource = new HikariDataSource(hikariConfig);
                yield Executors.newSingleThreadExecutor(r -> {
                    Thread t = new Thread(r, "H2-Worker");
                    t.setDaemon(true);
                    return t;
                });
            }
            default -> throw new IllegalArgumentException("Unsupported database type: " + String.valueOf(config.getType()));
        }, dataSource);
    }

    public static String insertAccount() {
        return switch (SQLSentences.getType()) {
            case DataBaseType.H2 -> "MERGE INTO accounts (uuid, player_name) KEY (uuid) VALUES (?, ?)";
            case DataBaseType.SQLITE -> "INSERT INTO accounts (uuid, player_name) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET player_name=excluded.player_name";
            case DataBaseType.MYSQL, DataBaseType.MARIADB -> "INSERT INTO accounts (uuid, player_name) VALUES (?, ?) ON DUPLICATE KEY UPDATE player_name=VALUES(player_name)";
            default -> throw new IllegalArgumentException("Unsupported DB type for insertAccount: " + String.valueOf(SQLSentences.getType()));
        };
    }

    public static String insertBalance() {
        return switch (SQLSentences.getType()) {
            case DataBaseType.H2 -> "MERGE INTO balances (account_uuid, currency_id, amount) KEY (account_uuid, currency_id) VALUES (?, ?, ?)";
            case DataBaseType.SQLITE -> "INSERT INTO balances (account_uuid, currency_id, amount) VALUES (?, ?, ?) ON CONFLICT(account_uuid, currency_id) DO UPDATE SET amount=excluded.amount";
            case DataBaseType.MYSQL, DataBaseType.MARIADB -> "INSERT INTO balances (account_uuid, currency_id, amount) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE amount=VALUES(amount)";
            default -> throw new IllegalArgumentException("Unsupported DB type for insertBalance: " + String.valueOf(SQLSentences.getType()));
        };
    }

    public static String insertTransaction() {
        return "INSERT INTO transactions (account_uuid, currency_id, amount, type, processed) VALUES (?, ?, ?, ?, ?)";
    }

    public static String markTransactionProcessed() {
        return "UPDATE transactions SET processed=TRUE WHERE id=?";
    }

    public static String selectPendingTransactions() {
        return "SELECT id, account_uuid, currency_id, amount, type FROM transactions WHERE processed=FALSE";
    }

    public static String selectAccountByUUID() {
        return "SELECT uuid, player_name FROM accounts WHERE uuid=?";
    }

    public static String selectBalancesByUUID() {
        return "SELECT currency_id, amount FROM balances WHERE account_uuid=?";
    }

    public static String selectTopBalances() {
        return "SELECT a.uuid, a.player_name, b.amount\nFROM accounts a\nJOIN balances b ON a.uuid=b.account_uuid\nWHERE b.currency_id=?\nORDER BY CAST(b.amount AS DECIMAL) DESC\nLIMIT ? OFFSET ?\n";
    }

    public static class Data {
        public ExecutorService service;
        public HikariDataSource dataSource;

        public Data(ExecutorService service, HikariDataSource dataSource) {
            this.service = service;
            this.dataSource = dataSource;
        }

        @Generated
        public ExecutorService getService() {
            return this.service;
        }

        @Generated
        public HikariDataSource getDataSource() {
            return this.dataSource;
        }

        @Generated
        public void setService(ExecutorService service) {
            this.service = service;
        }

        @Generated
        public void setDataSource(HikariDataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExecutorService this$service = this.getService();
            ExecutorService other$service = other.getService();
            if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
                return false;
            }
            HikariDataSource this$dataSource = this.getDataSource();
            HikariDataSource other$dataSource = other.getDataSource();
            return !(this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Data;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExecutorService $service = this.getService();
            result = result * 59 + ($service == null ? 43 : $service.hashCode());
            HikariDataSource $dataSource = this.getDataSource();
            result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SQLSentences.Data(service=" + String.valueOf(this.getService()) + ", dataSource=" + String.valueOf(this.getDataSource()) + ")";
        }
    }
}

