/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.gui;

import ca.landonjw.gooeylibs2.api.UIManager;
import ca.landonjw.gooeylibs2.api.button.GooeyButton;
import ca.landonjw.gooeylibs2.api.page.GooeyPage;
import ca.landonjw.gooeylibs2.api.page.Page;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.types.ChestTemplate;
import com.kingpixel.cobbleutils.Model.ItemModel;
import com.kingpixel.cobbleutils.Model.Rectangle;
import com.kingpixel.cobbleutils.util.AdventureTranslator;
import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.database.DatabaseFactory;
import com.kingpixel.ultraeconomy.models.Account;
import com.kingpixel.ultraeconomy.models.Currency;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.class_3222;

public class BalTopMenu {
    private String title = "Balance Top";
    private int rows = 6;
    private int playersPerPage = 45;
    private Rectangle rectangle = new Rectangle(this.rows);
    private ItemModel prevPageItem = new ItemModel(Integer.valueOf(45), "minecraft:arrow", "&aPrevious Page", List.of("&7Go to the previous page"), 0);
    private ItemModel closeItem = new ItemModel(Integer.valueOf(49), "minecraft:barrier", "&cClose", List.of("&7Close the menu"), 0);
    private ItemModel nextPageItem = new ItemModel(Integer.valueOf(53), "minecraft:arrow", "&aNext Page", List.of("&7Go to the next page"), 0);

    public void open(class_3222 player, int page, Currency currency) {
        CompletableFuture.runAsync(() -> {
            ChestTemplate template = ChestTemplate.builder((int)this.rows).build();
            List<Account> accounts = DatabaseFactory.INSTANCE.getTopBalances(currency, page, this.playersPerPage);
            boolean hasNextPage = accounts.size() > this.playersPerPage;
            List<Account> accountsPage = accounts.subList(0, Math.min(this.playersPerPage, accounts.size()));
            ArrayList<GooeyButton> buttons = new ArrayList<GooeyButton>();
            for (Account account : accountsPage) {
                buttons.add(account.getButton(currency));
            }
            this.rectangle.apply(template, buttons);
            if (page > 1) {
                this.prevPageItem.applyTemplate(template, this.prevPageItem.getButton(action -> this.open(player, page - 1, currency)));
            }
            this.closeItem.applyTemplate(template, this.closeItem.getButton(action -> UIManager.closeUI((class_3222)player)));
            if (hasNextPage) {
                this.nextPageItem.applyTemplate(template, this.nextPageItem.getButton(action -> this.open(player, page + 1, currency)));
            }
            GooeyPage pageMenu = GooeyPage.builder().template((Template)template).title(AdventureTranslator.toNative((String)this.title)).build();
            UIManager.openUIForcefully((class_3222)player, (Page)pageMenu);
        }, UltraEconomy.ULTRA_ECONOMY_EXECUTOR).exceptionally(e -> {
            e.printStackTrace();
            return null;
        });
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public int getRows() {
        return this.rows;
    }

    @Generated
    public int getPlayersPerPage() {
        return this.playersPerPage;
    }

    @Generated
    public Rectangle getRectangle() {
        return this.rectangle;
    }

    @Generated
    public ItemModel getPrevPageItem() {
        return this.prevPageItem;
    }

    @Generated
    public ItemModel getCloseItem() {
        return this.closeItem;
    }

    @Generated
    public ItemModel getNextPageItem() {
        return this.nextPageItem;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setRows(int rows) {
        this.rows = rows;
    }

    @Generated
    public void setPlayersPerPage(int playersPerPage) {
        this.playersPerPage = playersPerPage;
    }

    @Generated
    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    @Generated
    public void setPrevPageItem(ItemModel prevPageItem) {
        this.prevPageItem = prevPageItem;
    }

    @Generated
    public void setCloseItem(ItemModel closeItem) {
        this.closeItem = closeItem;
    }

    @Generated
    public void setNextPageItem(ItemModel nextPageItem) {
        this.nextPageItem = nextPageItem;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BalTopMenu)) {
            return false;
        }
        BalTopMenu other = (BalTopMenu)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        if (this.getPlayersPerPage() != other.getPlayersPerPage()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Rectangle this$rectangle = this.getRectangle();
        Rectangle other$rectangle = other.getRectangle();
        if (this$rectangle == null ? other$rectangle != null : !this$rectangle.equals(other$rectangle)) {
            return false;
        }
        ItemModel this$prevPageItem = this.getPrevPageItem();
        ItemModel other$prevPageItem = other.getPrevPageItem();
        if (this$prevPageItem == null ? other$prevPageItem != null : !this$prevPageItem.equals(other$prevPageItem)) {
            return false;
        }
        ItemModel this$closeItem = this.getCloseItem();
        ItemModel other$closeItem = other.getCloseItem();
        if (this$closeItem == null ? other$closeItem != null : !this$closeItem.equals(other$closeItem)) {
            return false;
        }
        ItemModel this$nextPageItem = this.getNextPageItem();
        ItemModel other$nextPageItem = other.getNextPageItem();
        return !(this$nextPageItem == null ? other$nextPageItem != null : !this$nextPageItem.equals(other$nextPageItem));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BalTopMenu;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRows();
        result = result * 59 + this.getPlayersPerPage();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Rectangle $rectangle = this.getRectangle();
        result = result * 59 + ($rectangle == null ? 43 : $rectangle.hashCode());
        ItemModel $prevPageItem = this.getPrevPageItem();
        result = result * 59 + ($prevPageItem == null ? 43 : $prevPageItem.hashCode());
        ItemModel $closeItem = this.getCloseItem();
        result = result * 59 + ($closeItem == null ? 43 : $closeItem.hashCode());
        ItemModel $nextPageItem = this.getNextPageItem();
        result = result * 59 + ($nextPageItem == null ? 43 : $nextPageItem.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BalTopMenu(title=" + this.getTitle() + ", rows=" + this.getRows() + ", playersPerPage=" + this.getPlayersPerPage() + ", rectangle=" + String.valueOf(this.getRectangle()) + ", prevPageItem=" + String.valueOf(this.getPrevPageItem()) + ", closeItem=" + String.valueOf(this.getCloseItem()) + ", nextPageItem=" + String.valueOf(this.getNextPageItem()) + ")";
    }
}

