/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.manager;

import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.ultraeconomy.UltraEconomy;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PlayerMessageQueueManager {
    private static final ConcurrentHashMap<UUID, Queue<Runnable>> MESSAGE_QUEUES = new ConcurrentHashMap();
    public static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor();

    public static void enqueue(UUID playerUUID, Runnable messageAction) {
        MESSAGE_QUEUES.computeIfAbsent(playerUUID, id -> new ConcurrentLinkedQueue()).add(messageAction);
    }

    private static void processQueues() {
        for (Map.Entry<UUID, Queue<Runnable>> entry : MESSAGE_QUEUES.entrySet()) {
            Queue<Runnable> queue;
            UUID playerUUID;
            block4: {
                playerUUID = entry.getKey();
                queue = entry.getValue();
                Runnable action = queue.poll();
                if (action != null) {
                    try {
                        action.run();
                    }
                    catch (Exception e) {
                        if (!UltraEconomy.config.isDebug()) break block4;
                        CobbleUtils.LOGGER.error("ultraeconomy", "Error al enviar mensaje en cola: " + e.getMessage());
                    }
                }
            }
            if (!queue.isEmpty()) continue;
            MESSAGE_QUEUES.remove(playerUUID);
        }
    }

    static {
        SCHEDULER.scheduleAtFixedRate(PlayerMessageQueueManager::processQueues, 0L, UltraEconomy.config.getBetweenMessagesDelay().toMillis(), TimeUnit.MILLISECONDS);
    }
}

