/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.mixins.impactor;

import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.api.UltraEconomyApi;
import com.kingpixel.ultraeconomy.models.Currency;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.economy.transactions.EconomyTransferTransaction;
import net.impactdev.impactor.api.economy.transactions.details.EconomyTransactionType;
import net.impactdev.impactor.core.economy.accounts.ImpactorAccount;
import net.impactdev.impactor.core.economy.transactions.composers.BaseTransactionComposer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ImpactorAccount.class})
public abstract class ImpactorAccountMixin {
    @Unique
    private final Map<net.impactdev.impactor.api.economy.currency.Currency, Currency> currencyIdCache = new HashMap<net.impactdev.impactor.api.economy.currency.Currency, Currency>();

    @Unique
    private String getCurrencyId(net.impactdev.impactor.api.economy.currency.Currency currency) {
        return this.currencyIdCache.computeIfAbsent(currency, c -> UltraEconomyApi.getCurrency(c.key().value())).getId();
    }

    @Inject(method={"deposit(Ljava/math/BigDecimal;)Lnet/impactdev/impactor/api/economy/transactions/EconomyTransaction;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void deposit(BigDecimal amount, CallbackInfoReturnable<EconomyTransaction> cir) {
        if (UltraEconomy.migrationDone) {
            ImpactorAccount self = (ImpactorAccount)this;
            UltraEconomyApi.deposit(self.owner(), this.getCurrencyId(self.currency()), amount);
            cir.setReturnValue((Object)EconomyTransaction.compose().account((Account)self).amount(amount).type(EconomyTransactionType.DEPOSIT).build());
        }
    }

    @Inject(method={"deposit(Lnet/impactdev/impactor/core/economy/transactions/composers/BaseTransactionComposer;)Lnet/impactdev/impactor/api/economy/transactions/EconomyTransaction;"}, at={@At(value="HEAD")}, remap=false)
    private void deposit(BaseTransactionComposer composer, CallbackInfoReturnable<EconomyTransaction> cir) {
        if (UltraEconomy.migrationDone) {
            ImpactorAccount self = (ImpactorAccount)this;
            BigDecimal amount = composer.amount();
            UltraEconomyApi.deposit(self.owner(), this.getCurrencyId(self.currency()), amount);
        }
    }

    @Inject(method={"lambda$deposit$6"}, at={@At(value="HEAD")}, remap=false)
    private void depositAsync(BigDecimal amount, CallbackInfoReturnable<EconomyTransaction> cir) {
        if (UltraEconomy.migrationDone) {
            ImpactorAccount self = (ImpactorAccount)this;
            UltraEconomyApi.deposit(self.owner(), this.getCurrencyId(self.currency()), amount);
            cir.setReturnValue((Object)EconomyTransaction.compose().account((Account)self).amount(amount).type(EconomyTransactionType.DEPOSIT).build());
        }
    }

    @Inject(method={"withdraw(Ljava/math/BigDecimal;)Lnet/impactdev/impactor/api/economy/transactions/EconomyTransaction;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void withdraw(BigDecimal amount, CallbackInfoReturnable<EconomyTransaction> cir) {
        if (UltraEconomy.migrationDone) {
            ImpactorAccount self = (ImpactorAccount)this;
            UltraEconomyApi.withdraw(self.owner(), this.getCurrencyId(self.currency()), amount);
            cir.setReturnValue((Object)EconomyTransaction.compose().account((Account)self).amount(amount).type(EconomyTransactionType.WITHDRAW).build());
        }
    }

    @Inject(method={"transfer(Lnet/impactdev/impactor/api/economy/accounts/Account;Ljava/math/BigDecimal;)Lnet/impactdev/impactor/api/economy/transactions/EconomyTransferTransaction;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void transfer(Account target, BigDecimal amount, CallbackInfoReturnable<EconomyTransferTransaction> cir) {
        if (UltraEconomy.migrationDone) {
            ImpactorAccount self = (ImpactorAccount)this;
            UltraEconomyApi.transfer(self.owner(), target.owner(), this.getCurrencyId(self.currency()), amount);
            cir.setReturnValue((Object)EconomyTransferTransaction.compose().from((Account)self).to(target).amount(amount).build());
        }
    }

    @Inject(method={"set(Ljava/math/BigDecimal;)Lnet/impactdev/impactor/api/economy/transactions/EconomyTransaction;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void set(BigDecimal amount, CallbackInfoReturnable<EconomyTransaction> cir) {
        if (UltraEconomy.migrationDone) {
            ImpactorAccount self = (ImpactorAccount)this;
            UltraEconomyApi.setBalance(self.owner(), this.getCurrencyId(self.currency()), amount);
            cir.setReturnValue((Object)EconomyTransaction.compose().account((Account)self).amount(amount).type(EconomyTransactionType.SET).build());
        }
    }

    @Inject(method={"save"}, at={@At(value="HEAD")}, remap=false)
    private void save(CallbackInfo ci) {
        if (UltraEconomy.migrationDone) {
            UltraEconomyApi.saveAccount(UltraEconomyApi.getAccount(((ImpactorAccount)this).owner()));
        }
    }

    @Inject(method={"balance"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void balance(CallbackInfoReturnable<BigDecimal> cir) {
        if (UltraEconomy.migrationDone) {
            ImpactorAccount self = (ImpactorAccount)this;
            com.kingpixel.ultraeconomy.models.Account account = UltraEconomyApi.getAccount(self.owner());
            BigDecimal balance = BigDecimal.ZERO;
            if (account != null) {
                balance = UltraEconomyApi.getBalance(self.owner(), this.getCurrencyId(self.currency()));
            }
            cir.setReturnValue((Object)balance);
        }
    }
}

