/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.mixins.impactor;

import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.config.Currencies;
import com.kingpixel.ultraeconomy.models.Currency;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.impactdev.impactor.core.economy.currency.ImpactorCurrency;
import net.kyori.adventure.text.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ImpactorCurrency.class})
public abstract class ImpactorCurrencyMixin {
    @Unique
    private Map<ImpactorCurrency, String> currencyIdCache = new HashMap<ImpactorCurrency, String>();

    @Inject(method={"format"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void format(BigDecimal amount, boolean condensed, Locale locale, CallbackInfoReturnable<Component> cir) {
        if (UltraEconomy.migrationDone) {
            ImpactorCurrency self = (ImpactorCurrency)this;
            String id = this.getCurrencyId(self);
            if (id == null) {
                return;
            }
            Currency currency = Currencies.getCurrency(id);
            if (currency != null) {
                String formatted = currency.format(amount, locale);
                cir.setReturnValue((Object)Component.text((String)formatted));
            }
        }
    }

    @Unique
    private String getCurrencyId(ImpactorCurrency currency) {
        if (currency == null) {
            return null;
        }
        return this.currencyIdCache.computeIfAbsent(currency, c -> c.key().value().replace("impactor:", ""));
    }

    @Inject(method={"symbol"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void symbol(CallbackInfoReturnable<Component> cir) {
        if (UltraEconomy.migrationDone) {
            ImpactorCurrency self = (ImpactorCurrency)this;
            String id = this.getCurrencyId(self);
            if (id == null) {
                return;
            }
            Currency currency = Currencies.getCurrency(id);
            if (currency != null) {
                cir.setReturnValue((Object)Component.text((String)currency.getSymbol()));
            }
        }
    }
}

