/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.models;

import ca.landonjw.gooeylibs2.api.button.GooeyButton;
import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.util.AdventureTranslator;
import com.kingpixel.cobbleutils.util.PlayerUtils;
import com.kingpixel.ultraeconomy.config.Currencies;
import com.kingpixel.ultraeconomy.models.Currency;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.minecraft.class_3222;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.bson.Document;
import org.bson.types.Decimal128;

public class Account {
    private long rank;
    private UUID playerUUID;
    private String playerName;
    private final Map<String, BigDecimal> balances;

    public Account(class_3222 player) {
        this.playerUUID = player.method_5667();
        this.playerName = player.method_7334().getName();
        this.balances = this.defaultBalances();
    }

    public Account(UUID playerUUID) {
        class_3222 player = CobbleUtils.server.method_3760().method_14602(playerUUID);
        if (player != null) {
            this.playerName = player.method_7334().getName();
        }
        this.playerUUID = playerUUID;
        this.balances = this.defaultBalances();
    }

    public Account(UUID uuid, Map<String, BigDecimal> balances) {
        class_3222 player = CobbleUtils.server.method_3760().method_14602(uuid);
        if (player != null) {
            this.playerName = player.method_7334().getName();
        }
        this.playerUUID = uuid;
        this.balances = new ConcurrentHashMap<String, BigDecimal>(balances);
        this.fix();
    }

    public Account(UUID uuid, String playerName, Map<String, BigDecimal> balances) {
        this.playerUUID = uuid;
        this.playerName = playerName;
        this.balances = new ConcurrentHashMap<String, BigDecimal>(balances);
        this.fix();
    }

    public Account(UUID playerUUID, String playerName) {
        this.playerUUID = playerUUID;
        this.playerName = playerName;
        this.balances = this.defaultBalances();
    }

    public static Account fromDocument(Document doc) {
        UUID uuid = UUID.fromString(doc.getString((Object)"uuid"));
        String playerName = doc.getString((Object)"player_name");
        HashMap<String, BigDecimal> balances = new HashMap<String, BigDecimal>();
        Document balanceDoc = (Document)doc.get((Object)"balances", Document.class);
        if (balanceDoc != null) {
            for (Map.Entry entry : balanceDoc.entrySet()) {
                String key = (String)entry.getKey();
                Object rawValue = entry.getValue();
                if (rawValue instanceof Decimal128) {
                    Decimal128 dec = (Decimal128)rawValue;
                    balances.put(key, dec.bigDecimalValue());
                    continue;
                }
                if (!(rawValue instanceof String)) continue;
                String str = (String)rawValue;
                try {
                    balances.put(key, new BigDecimal(str));
                }
                catch (NumberFormatException e) {
                    CobbleUtils.LOGGER.warn("Invalid balance format for " + key + " in account " + String.valueOf(uuid) + ": " + str);
                }
            }
        }
        return new Account(uuid, playerName, balances);
    }

    public Document toDocument() {
        Document doc = new Document();
        doc.append("uuid", (Object)this.playerUUID.toString());
        doc.append("player_name", (Object)this.playerName);
        Document balanceDoc = new Document();
        for (Map.Entry<String, BigDecimal> entry : this.balances.entrySet()) {
            balanceDoc.append(entry.getKey(), (Object)new Decimal128(entry.getValue()));
        }
        doc.append("balances", (Object)balanceDoc);
        return doc;
    }

    public BigDecimal getBalance(Currency currency) {
        return this.balances.getOrDefault(currency.getId(), null);
    }

    public boolean addBalance(Currency currency, BigDecimal amount) {
        this.balances.merge(currency.getId(), amount, BigDecimal::add);
        return true;
    }

    public boolean removeBalance(Currency currency, BigDecimal amount) {
        this.balances.merge(currency.getId(), amount, BigDecimal::subtract);
        return true;
    }

    public BigDecimal setBalance(Currency currency, BigDecimal amount) {
        this.balances.put(currency.getId(), amount);
        return amount;
    }

    public boolean hasEnoughBalance(Currency currency, BigDecimal amount) {
        return this.getBalance(currency).compareTo(amount) >= 0;
    }

    public void fix() {
        Currencies.getCurrencyMap().forEach((k, v) -> this.balances.putIfAbsent(v.getId(), v.getDefaultBalance()));
    }

    private Map<String, BigDecimal> defaultBalances() {
        ConcurrentHashMap<String, BigDecimal> defaults = new ConcurrentHashMap<String, BigDecimal>();
        Currencies.getCurrencyMap().forEach((k, v) -> defaults.put(v.getId(), v.getDefaultBalance()));
        return defaults;
    }

    public GooeyButton getButton(Currency currency) {
        List<CallSite> lore = List.of("\u00a77Balance: \u00a7e" + currency.format(this.getBalance(currency)));
        return GooeyButton.builder().display(PlayerUtils.getHeadItem((UUID)this.playerUUID)).with(class_9334.field_49631, (Object)AdventureTranslator.toNative((String)(this.rank + ". " + this.playerName))).with(class_9334.field_49632, (Object)new class_9290(AdventureTranslator.toNativeL(lore))).build();
    }

    @Generated
    public long getRank() {
        return this.rank;
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Generated
    public String getPlayerName() {
        return this.playerName;
    }

    @Generated
    public Map<String, BigDecimal> getBalances() {
        return this.balances;
    }

    @Generated
    public void setRank(long rank) {
        this.rank = rank;
    }

    @Generated
    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Generated
    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRank() != other.getRank()) {
            return false;
        }
        UUID this$playerUUID = this.getPlayerUUID();
        UUID other$playerUUID = other.getPlayerUUID();
        if (this$playerUUID == null ? other$playerUUID != null : !((Object)this$playerUUID).equals(other$playerUUID)) {
            return false;
        }
        String this$playerName = this.getPlayerName();
        String other$playerName = other.getPlayerName();
        if (this$playerName == null ? other$playerName != null : !this$playerName.equals(other$playerName)) {
            return false;
        }
        Map<String, BigDecimal> this$balances = this.getBalances();
        Map<String, BigDecimal> other$balances = other.getBalances();
        return !(this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $rank = this.getRank();
        result = result * 59 + (int)($rank >>> 32 ^ $rank);
        UUID $playerUUID = this.getPlayerUUID();
        result = result * 59 + ($playerUUID == null ? 43 : ((Object)$playerUUID).hashCode());
        String $playerName = this.getPlayerName();
        result = result * 59 + ($playerName == null ? 43 : $playerName.hashCode());
        Map<String, BigDecimal> $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Account(rank=" + this.getRank() + ", playerUUID=" + String.valueOf(this.getPlayerUUID()) + ", playerName=" + this.getPlayerName() + ", balances=" + String.valueOf(this.getBalances()) + ")";
    }
}

