/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.models;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.kingpixel.cobbleutils.util.AdventureTranslator;
import com.kingpixel.ultraeconomy.UltraEconomy;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class Currency {
    private transient String id;
    private boolean primary;
    private boolean transferable;
    private BigDecimal defaultBalance;
    private byte decimals;
    private String symbol;
    private String format = "<symbol>&6<amount> <name>";
    private String singular = "Dollar";
    private String plural = "Dollars";
    private String[] suffixes = new String[]{"", "K", "M", "B", "T"};
    private String[] currencyIds = new String[0];
    private transient Map<Locale, Cache<@NotNull BigDecimal, String>> formatCache;
    private transient Map<Locale, Cache<@NotNull BigDecimal, class_2561>> formatTextCache;
    private transient Map<Locale, Cache<@NotNull BigDecimal, class_2561>> formatSimpleTextCache;
    private transient Map<Locale, Cache<@NotNull BigDecimal, class_2561>> formatAmountTextCache;
    private transient class_2561 symbolText;

    public class_2561 getSymbolText() {
        return this.symbolText == null ? (this.symbolText = AdventureTranslator.toNative((String)this.symbol)) : this.symbolText;
    }

    public Currency() {
    }

    public Currency(boolean primary, byte decimals, String symbol, String[] currencyIds) {
        this.primary = primary;
        this.transferable = true;
        this.decimals = decimals;
        this.defaultBalance = BigDecimal.ZERO;
        this.symbol = symbol;
        this.currencyIds = currencyIds;
    }

    public void fix() {
        if (this.format == null || this.format.isEmpty()) {
            this.format = "<symbol>&6<amount> <name>";
        }
        if (this.singular == null || this.singular.isEmpty()) {
            this.singular = "Dollar";
        }
        if (this.plural == null || this.plural.isEmpty()) {
            this.plural = "Dollars";
        }
        if (this.suffixes == null || this.suffixes.length == 0) {
            this.suffixes = new String[]{"", "K", "M", "B", "T"};
        }
        if (this.decimals < 0) {
            this.decimals = (byte)2;
        }
        if (this.defaultBalance == null) {
            this.defaultBalance = BigDecimal.ZERO;
        }
        if (this.symbol == null) {
            this.symbol = "$";
        }
        if (this.currencyIds == null) {
            this.currencyIds = new String[0];
        }
    }

    public void init() {
        this.formatCache = new ConcurrentHashMap<Locale, Cache<BigDecimal, String>>();
        this.formatTextCache = new ConcurrentHashMap<Locale, Cache<BigDecimal, class_2561>>();
        this.formatSimpleTextCache = new ConcurrentHashMap<Locale, Cache<BigDecimal, class_2561>>();
        this.formatAmountTextCache = new ConcurrentHashMap<Locale, Cache<BigDecimal, class_2561>>();
    }

    private Cache<BigDecimal, String> getFormatCacheForLocale(Locale locale) {
        return this.formatCache.computeIfAbsent(locale, loc -> Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(5000L).build());
    }

    public String format(BigDecimal value) {
        return (String)this.getFormatCacheForLocale(Locale.US).get((Object)value, v -> this.replace((BigDecimal)v, Locale.US));
    }

    public String format(BigDecimal value, Locale locale) {
        return (String)this.getFormatCacheForLocale(locale).get((Object)value, v -> this.replace((BigDecimal)v, locale));
    }

    private String replace(BigDecimal value, Locale locale) {
        StringBuilder sb = new StringBuilder();
        int length = this.format.length();
        for (int i = 0; i < length; ++i) {
            char c = this.format.charAt(i);
            if (c == '<') {
                if (this.format.startsWith("<symbol>", i)) {
                    sb.append(this.symbol);
                    i += "<symbol>".length() - 1;
                    continue;
                }
                if (this.format.startsWith("<amount>", i)) {
                    sb.append(this.formatSimpleAmount(value, locale));
                    i += "<amount>".length() - 1;
                    continue;
                }
                if (this.format.startsWith("<short_amount>", i)) {
                    sb.append(this.formatAmount(value, locale));
                    i += "<short_amount>".length() - 1;
                    continue;
                }
                if (this.format.startsWith("<name>", i)) {
                    sb.append(value.compareTo(BigDecimal.ONE) == 0 ? this.singular : this.plural);
                    i += "<name>".length() - 1;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String formatSimpleAmount(BigDecimal value, Locale locale) {
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        nf.setMaximumFractionDigits(this.decimals);
        nf.setMinimumFractionDigits(0);
        nf.setGroupingUsed(true);
        return nf.format(value);
    }

    public String formatAmount(BigDecimal value) {
        return this.formatAmount(value, Locale.US);
    }

    public String formatAmount(BigDecimal value, Locale locale) {
        int suffixIndex;
        if (value == null) {
            return "0";
        }
        BigDecimal thousand = BigDecimal.valueOf(1000L);
        for (suffixIndex = 0; value.compareTo(thousand) >= 0 && suffixIndex < this.suffixes.length - 1; ++suffixIndex) {
            value = value.divide(thousand, 2, RoundingMode.DOWN);
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        DecimalFormat df = new DecimalFormat();
        df.setDecimalFormatSymbols(symbols);
        df.setMaximumFractionDigits(Math.max(this.decimals, UltraEconomy.config.getAdjustmentShortName()));
        df.setMinimumFractionDigits(0);
        df.setGroupingUsed(false);
        df.setRoundingMode(RoundingMode.DOWN);
        return df.format(value) + this.suffixes[suffixIndex];
    }

    public class_2561 formatText(BigDecimal value) {
        return this.formatText(value, Locale.US);
    }

    public class_2561 formatText(BigDecimal value, Locale locale) {
        return (class_2561)this.getFormatTextCacheForLocale(locale).get((Object)value, v -> AdventureTranslator.toNative((String)this.format((BigDecimal)v, locale)));
    }

    private Cache<@NotNull BigDecimal, class_2561> getFormatTextCacheForLocale(Locale locale) {
        return this.formatTextCache.computeIfAbsent(locale, loc -> Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(5000L).build());
    }

    public class_2561 formatSimpleAmountText(BigDecimal balance, Locale locale) {
        return (class_2561)this.getFormatSimpleTextCacheForLocale(locale).get((Object)balance, v -> AdventureTranslator.toNative((String)this.formatSimpleAmount((BigDecimal)v, locale)));
    }

    private Cache<@NotNull BigDecimal, class_2561> getFormatSimpleTextCacheForLocale(Locale locale) {
        return this.formatSimpleTextCache.computeIfAbsent(locale, loc -> Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(5000L).build());
    }

    public class_2561 formatAmountText(BigDecimal balance, Locale locale) {
        return (class_2561)this.getFormatAmountTextCacheForLocale(locale).get((Object)balance, v -> AdventureTranslator.toNative((String)this.formatAmount((BigDecimal)v, locale)));
    }

    private Cache<@NotNull BigDecimal, class_2561> getFormatAmountTextCacheForLocale(Locale locale) {
        return this.formatAmountTextCache.computeIfAbsent(locale, loc -> Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(5000L).build());
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public boolean isPrimary() {
        return this.primary;
    }

    @Generated
    public boolean isTransferable() {
        return this.transferable;
    }

    @Generated
    public BigDecimal getDefaultBalance() {
        return this.defaultBalance;
    }

    @Generated
    public byte getDecimals() {
        return this.decimals;
    }

    @Generated
    public String getSymbol() {
        return this.symbol;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public String getSingular() {
        return this.singular;
    }

    @Generated
    public String getPlural() {
        return this.plural;
    }

    @Generated
    public String[] getSuffixes() {
        return this.suffixes;
    }

    @Generated
    public String[] getCurrencyIds() {
        return this.currencyIds;
    }

    @Generated
    public Map<Locale, Cache<@NotNull BigDecimal, String>> getFormatCache() {
        return this.formatCache;
    }

    @Generated
    public Map<Locale, Cache<@NotNull BigDecimal, class_2561>> getFormatTextCache() {
        return this.formatTextCache;
    }

    @Generated
    public Map<Locale, Cache<@NotNull BigDecimal, class_2561>> getFormatSimpleTextCache() {
        return this.formatSimpleTextCache;
    }

    @Generated
    public Map<Locale, Cache<@NotNull BigDecimal, class_2561>> getFormatAmountTextCache() {
        return this.formatAmountTextCache;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    @Generated
    public void setTransferable(boolean transferable) {
        this.transferable = transferable;
    }

    @Generated
    public void setDefaultBalance(BigDecimal defaultBalance) {
        this.defaultBalance = defaultBalance;
    }

    @Generated
    public void setDecimals(byte decimals) {
        this.decimals = decimals;
    }

    @Generated
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @Generated
    public void setFormat(String format) {
        this.format = format;
    }

    @Generated
    public void setSingular(String singular) {
        this.singular = singular;
    }

    @Generated
    public void setPlural(String plural) {
        this.plural = plural;
    }

    @Generated
    public void setSuffixes(String[] suffixes) {
        this.suffixes = suffixes;
    }

    @Generated
    public void setCurrencyIds(String[] currencyIds) {
        this.currencyIds = currencyIds;
    }

    @Generated
    public void setFormatCache(Map<Locale, Cache<@NotNull BigDecimal, String>> formatCache) {
        this.formatCache = formatCache;
    }

    @Generated
    public void setFormatTextCache(Map<Locale, Cache<@NotNull BigDecimal, class_2561>> formatTextCache) {
        this.formatTextCache = formatTextCache;
    }

    @Generated
    public void setFormatSimpleTextCache(Map<Locale, Cache<@NotNull BigDecimal, class_2561>> formatSimpleTextCache) {
        this.formatSimpleTextCache = formatSimpleTextCache;
    }

    @Generated
    public void setFormatAmountTextCache(Map<Locale, Cache<@NotNull BigDecimal, class_2561>> formatAmountTextCache) {
        this.formatAmountTextCache = formatAmountTextCache;
    }

    @Generated
    public void setSymbolText(class_2561 symbolText) {
        this.symbolText = symbolText;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Currency)) {
            return false;
        }
        Currency other = (Currency)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPrimary() != other.isPrimary()) {
            return false;
        }
        if (this.isTransferable() != other.isTransferable()) {
            return false;
        }
        if (this.getDecimals() != other.getDecimals()) {
            return false;
        }
        BigDecimal this$defaultBalance = this.getDefaultBalance();
        BigDecimal other$defaultBalance = other.getDefaultBalance();
        if (this$defaultBalance == null ? other$defaultBalance != null : !((Object)this$defaultBalance).equals(other$defaultBalance)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$singular = this.getSingular();
        String other$singular = other.getSingular();
        if (this$singular == null ? other$singular != null : !this$singular.equals(other$singular)) {
            return false;
        }
        String this$plural = this.getPlural();
        String other$plural = other.getPlural();
        if (this$plural == null ? other$plural != null : !this$plural.equals(other$plural)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSuffixes(), other.getSuffixes())) {
            return false;
        }
        return Arrays.deepEquals(this.getCurrencyIds(), other.getCurrencyIds());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Currency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrimary() ? 79 : 97);
        result = result * 59 + (this.isTransferable() ? 79 : 97);
        result = result * 59 + this.getDecimals();
        BigDecimal $defaultBalance = this.getDefaultBalance();
        result = result * 59 + ($defaultBalance == null ? 43 : ((Object)$defaultBalance).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $singular = this.getSingular();
        result = result * 59 + ($singular == null ? 43 : $singular.hashCode());
        String $plural = this.getPlural();
        result = result * 59 + ($plural == null ? 43 : $plural.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSuffixes());
        result = result * 59 + Arrays.deepHashCode(this.getCurrencyIds());
        return result;
    }

    @Generated
    public String toString() {
        return "Currency(id=" + this.getId() + ", primary=" + this.isPrimary() + ", transferable=" + this.isTransferable() + ", defaultBalance=" + String.valueOf(this.getDefaultBalance()) + ", decimals=" + this.getDecimals() + ", symbol=" + this.getSymbol() + ", format=" + this.getFormat() + ", singular=" + this.getSingular() + ", plural=" + this.getPlural() + ", suffixes=" + Arrays.deepToString(this.getSuffixes()) + ", currencyIds=" + Arrays.deepToString(this.getCurrencyIds()) + ", formatCache=" + String.valueOf(this.getFormatCache()) + ", formatTextCache=" + String.valueOf(this.getFormatTextCache()) + ", formatSimpleTextCache=" + String.valueOf(this.getFormatSimpleTextCache()) + ", formatAmountTextCache=" + String.valueOf(this.getFormatAmountTextCache()) + ", symbolText=" + String.valueOf(this.getSymbolText()) + ")";
    }
}

