/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.models;

import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.cobbleutils.Model.EconomyUse;
import com.kingpixel.cobbleutils.api.EconomyApi;
import com.kingpixel.cobbleutils.command.suggests.CobbleUtilsSuggests;
import com.kingpixel.cobbleutils.command.suggests.PlayerOfflineAndOnline;
import com.kingpixel.cobbleutils.database.users.UserModel;
import com.kingpixel.ultraeconomy.UltraEconomy;
import com.kingpixel.ultraeconomy.api.UltraEconomyApi;
import com.kingpixel.ultraeconomy.models.Account;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class MigrationConfig {
    private boolean active = false;
    private String economyId = "IMPACTOR";
    private List<EconomyUse> economyUses = List.of(new EconomyUse("IMPACTOR", "impactor:dollars"));
    private List<String> currencyIds = List.of("dollars");

    public void startMigration() {
        if (!this.active) {
            UltraEconomy.migrationDone = true;
            return;
        }
        CompletableFuture.runAsync(() -> {
            long start = System.currentTimeMillis();
            CobbleUtils.LOGGER.info("Migration started ->");
            CobbleUtils.LOGGER.info("Order of economy uses:");
            for (EconomyUse use : this.economyUses) {
                CobbleUtils.LOGGER.info("- " + use.getEconomyId() + " -> " + use.getCurrency());
            }
            CobbleUtils.LOGGER.info("Order of UltraEconomy currencies:");
            for (String currencyId : this.currencyIds) {
                CobbleUtils.LOGGER.info("- " + currencyId);
            }
            List playerUUIDs = CobbleUtilsSuggests.SUGGESTS_PLAYER_OFFLINE_AND_ONLINE.getPlayerNames();
            try {
                CobbleUtils.LOGGER.info("Waiting 10s before starting migration to let the server breathe...");
                Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
            }
            catch (InterruptedException e) {
                CobbleUtils.LOGGER.error("Migration sleep interrupted");
                e.printStackTrace();
                Thread.currentThread().interrupt();
                return;
            }
            for (String uuid : playerUUIDs) {
                Optional dataOpt = CobbleUtilsSuggests.SUGGESTS_PLAYER_OFFLINE_AND_ONLINE.getPlayer(uuid);
                if (dataOpt.isEmpty()) {
                    CobbleUtils.LOGGER.warn("Could not find player with UUID " + uuid + ", skipping");
                    continue;
                }
                PlayerOfflineAndOnline.DataResultPlayer dataResultPlayer = (PlayerOfflineAndOnline.DataResultPlayer)dataOpt.get();
                UserModel userModel = dataResultPlayer.user();
                Account account = UltraEconomyApi.getAccount(userModel.getPlayerUUID());
                if (account == null) {
                    account = new Account(userModel.getPlayerUUID(), userModel.getPlayerName());
                    UltraEconomyApi.saveAccount(account);
                    CobbleUtils.LOGGER.info("Created new account for player " + userModel.getPlayerName());
                }
                UltraEconomyApi.getAccount(account.getPlayerUUID());
                for (int i = 0; i < this.economyUses.size(); ++i) {
                    EconomyUse economyUse = this.economyUses.get(i);
                    String currencyId = this.currencyIds.get(Math.min(i, this.currencyIds.size() - 1));
                    BigDecimal balance = EconomyApi.getBalance((UUID)userModel.getPlayerUUID(), (EconomyUse)economyUse);
                    if (balance == null) {
                        CobbleUtils.LOGGER.warn("Balance for player " + userModel.getPlayerName() + " is null, skipping");
                        continue;
                    }
                    if (balance.compareTo(BigDecimal.ZERO) <= 0) {
                        CobbleUtils.LOGGER.info("Balance for player " + userModel.getPlayerName() + " is zero or negative, skipping");
                        continue;
                    }
                    UltraEconomyApi.setBalance(userModel.getPlayerUUID(), currencyId, balance);
                    CobbleUtils.LOGGER.info("Migrated " + String.valueOf(balance) + " " + currencyId + " for player " + userModel.getPlayerName());
                }
                UltraEconomyApi.saveAccount(account);
            }
            long end = System.currentTimeMillis();
            CobbleUtils.LOGGER.info("Migration took " + (end - start) + "ms. Migration finished.");
            this.active = false;
            try {
                UltraEconomy.config.writeConfig();
            }
            catch (Exception e) {
                CobbleUtils.LOGGER.error("Failed to write UltraEconomy config after migration");
                e.printStackTrace();
            }
            UltraEconomy.migrationDone = true;
        }, UltraEconomy.ULTRA_ECONOMY_EXECUTOR).exceptionally(e -> {
            CobbleUtils.LOGGER.error("Migration failed with exception:");
            e.printStackTrace();
            UltraEconomy.migrationDone = true;
            return null;
        });
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public String getEconomyId() {
        return this.economyId;
    }

    @Generated
    public List<EconomyUse> getEconomyUses() {
        return this.economyUses;
    }

    @Generated
    public List<String> getCurrencyIds() {
        return this.currencyIds;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public void setEconomyId(String economyId) {
        this.economyId = economyId;
    }

    @Generated
    public void setEconomyUses(List<EconomyUse> economyUses) {
        this.economyUses = economyUses;
    }

    @Generated
    public void setCurrencyIds(List<String> currencyIds) {
        this.currencyIds = currencyIds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrationConfig)) {
            return false;
        }
        MigrationConfig other = (MigrationConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        String this$economyId = this.getEconomyId();
        String other$economyId = other.getEconomyId();
        if (this$economyId == null ? other$economyId != null : !this$economyId.equals(other$economyId)) {
            return false;
        }
        List<EconomyUse> this$economyUses = this.getEconomyUses();
        List<EconomyUse> other$economyUses = other.getEconomyUses();
        if (this$economyUses == null ? other$economyUses != null : !((Object)this$economyUses).equals(other$economyUses)) {
            return false;
        }
        List<String> this$currencyIds = this.getCurrencyIds();
        List<String> other$currencyIds = other.getCurrencyIds();
        return !(this$currencyIds == null ? other$currencyIds != null : !((Object)this$currencyIds).equals(other$currencyIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MigrationConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        String $economyId = this.getEconomyId();
        result = result * 59 + ($economyId == null ? 43 : $economyId.hashCode());
        List<EconomyUse> $economyUses = this.getEconomyUses();
        result = result * 59 + ($economyUses == null ? 43 : ((Object)$economyUses).hashCode());
        List<String> $currencyIds = this.getCurrencyIds();
        result = result * 59 + ($currencyIds == null ? 43 : ((Object)$currencyIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MigrationConfig(active=" + this.isActive() + ", economyId=" + this.getEconomyId() + ", economyUses=" + String.valueOf(this.getEconomyUses()) + ", currencyIds=" + String.valueOf(this.getCurrencyIds()) + ")";
    }
}

