/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.placeholders;

import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.ultraeconomy.api.UltraEconomyApi;
import com.kingpixel.ultraeconomy.config.Currencies;
import com.kingpixel.ultraeconomy.models.Currency;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PlaceHolders {
    public static void register() {
        try {
            PlaceHolders.registerBalance();
            PlaceHolders.registerSymbol();
            PlaceHolders.registerAmount();
            PlaceHolders.registerShortAmount();
        }
        catch (Exception | NoClassDefFoundError ignored) {
            CobbleUtils.LOGGER.warn("Placeholders API not found, skipping placeholders registration.");
        }
    }

    private static void registerBalance() {
        Placeholders.register((class_2960)class_2960.method_60655((String)"ultraeconomy", (String)"balance"), (ctx, arg) -> {
            if (CobbleUtils.server == null || CobbleUtils.server.method_16043() || CobbleUtils.server.method_3750()) {
                return PlaceholderResult.invalid();
            }
            class_1297 entity = ctx.entity();
            if (entity == null) {
                return PlaceholderResult.invalid();
            }
            if (!(entity instanceof class_3222)) {
                return PlaceholderResult.invalid();
            }
            class_3222 player = (class_3222)entity;
            if (arg == null || arg.isEmpty()) {
                return PlaceholderResult.invalid();
            }
            Currency currency = Currencies.getCurrency(arg);
            return PlaceholderResult.value((class_2561)currency.formatText(UltraEconomyApi.getBalance(player.method_5667(), currency.getId()), UltraEconomyApi.getLocale(player)));
        });
    }

    private static void registerSymbol() {
        Placeholders.register((class_2960)class_2960.method_60655((String)"ultraeconomy", (String)"symbol"), (ctx, arg) -> {
            if (CobbleUtils.server == null || CobbleUtils.server.method_16043() || CobbleUtils.server.method_3750()) {
                return PlaceholderResult.invalid();
            }
            if (arg == null || arg.isEmpty()) {
                return PlaceholderResult.invalid();
            }
            Currency currency = Currencies.getCurrency(arg);
            return PlaceholderResult.value((class_2561)currency.getSymbolText());
        });
    }

    private static void registerAmount() {
        Placeholders.register((class_2960)class_2960.method_60655((String)"ultraeconomy", (String)"amount"), (ctx, arg) -> {
            if (CobbleUtils.server == null || CobbleUtils.server.method_16043() || CobbleUtils.server.method_3750()) {
                return PlaceholderResult.invalid();
            }
            class_1297 entity = ctx.entity();
            if (entity == null) {
                return PlaceholderResult.invalid();
            }
            if (!(entity instanceof class_3222)) {
                return PlaceholderResult.invalid();
            }
            class_3222 player = (class_3222)entity;
            if (arg == null || arg.isEmpty()) {
                return PlaceholderResult.invalid();
            }
            Currency currency = Currencies.getCurrency(arg);
            return PlaceholderResult.value((class_2561)currency.formatSimpleAmountText(UltraEconomyApi.getBalance(player.method_5667(), currency.getId()), UltraEconomyApi.getLocale(player)));
        });
    }

    private static void registerShortAmount() {
        Placeholders.register((class_2960)class_2960.method_60655((String)"ultraeconomy", (String)"short_amount"), (ctx, arg) -> {
            if (CobbleUtils.server == null || CobbleUtils.server.method_16043() || CobbleUtils.server.method_3750()) {
                return PlaceholderResult.invalid();
            }
            class_1297 entity = ctx.entity();
            if (entity == null) {
                return PlaceholderResult.invalid();
            }
            if (!(entity instanceof class_3222)) {
                return PlaceholderResult.invalid();
            }
            class_3222 player = (class_3222)entity;
            if (arg == null || arg.isEmpty()) {
                return PlaceholderResult.invalid();
            }
            Currency currency = Currencies.getCurrency(arg);
            return PlaceholderResult.value((class_2561)currency.formatAmountText(UltraEconomyApi.getBalance(player.method_5667(), currency.getId()), UltraEconomyApi.getLocale(player)));
        });
    }
}

