/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultraeconomy.services;

import com.kingpixel.cobbleutils.CobbleUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;

public class VaultService {
    public static Economy service;
    private static Boolean present;

    public static boolean isPresent() {
        if (present != null) {
            return present;
        }
        present = false;
        try {
            if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
                CobbleUtils.LOGGER.info("Cannot find Vault!");
                ArrayList<String> plugins = new ArrayList<String>();
                for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                    plugins.add(plugin.getName());
                }
                CobbleUtils.LOGGER.info("Report this to zonary123 Plugins to Vault -> " + String.valueOf(plugins));
            } else {
                RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
                if (rsp == null) {
                    CobbleUtils.LOGGER.info("Registered Service Provider for Economy.class not found");
                } else {
                    service = (Economy)rsp.getProvider();
                    CobbleUtils.LOGGER.info("Economy successfully hooked up");
                    CobbleUtils.LOGGER.info("Economy: " + service.getName());
                    present = true;
                }
            }
        }
        catch (Exception | NoClassDefFoundError | NoSuchMethodError e) {
            CobbleUtils.LOGGER.info("ultraeconomy", "This error can be ignored if you are not using Vault:");
            e.printStackTrace();
        }
        return present;
    }

    public static BigDecimal getBalance(@NotNull UUID uuid, @NotNull String currency) {
        if (service == null) {
            return BigDecimal.ZERO;
        }
        double balance = service.getBalance(Bukkit.getOfflinePlayer((UUID)uuid));
        return BigDecimal.valueOf(balance);
    }

    public static void setBalance(@NotNull UUID uuid, @NotNull String currency, BigDecimal amount) {
        if (service == null) {
            return;
        }
        double currentBalance = service.getBalance(Bukkit.getOfflinePlayer((UUID)uuid));
        double targetBalance = amount.doubleValue();
        double difference = targetBalance - currentBalance;
        if (difference > 0.0) {
            VaultService.deposit(uuid, currency, BigDecimal.valueOf(difference));
        } else if (difference < 0.0) {
            VaultService.withdraw(uuid, currency, BigDecimal.valueOf(-difference));
        }
    }

    public static boolean deposit(@NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal amount) {
        if (service == null) {
            return false;
        }
        return service.depositPlayer(Bukkit.getOfflinePlayer((UUID)uuid), amount.doubleValue()).transactionSuccess();
    }

    public static boolean withdraw(@NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal amount) {
        if (service == null) {
            return false;
        }
        return service.withdrawPlayer(Bukkit.getOfflinePlayer((UUID)uuid), amount.doubleValue()).transactionSuccess();
    }

    public static boolean hashEnoughBalance(@NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal amount) {
        if (service == null) {
            return false;
        }
        return service.has(Bukkit.getOfflinePlayer((UUID)uuid), amount.doubleValue());
    }

    @Generated
    public VaultService() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaultService)) {
            return false;
        }
        VaultService other = (VaultService)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VaultService;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "VaultService()";
    }
}

