package meanwhile131.elytrainfinite;

import net.fabricmc.api.ClientModInitializer;

import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;

enum FlyState {
	TOGGLED_OFF,
	NOT_FLYING,
	PITCHING_DOWN,
	GLIDING_DOWN
};

public class ElytraInfinite implements ClientModInitializer {
	public static final String MOD_ID = "elytra-infinite";
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	static final float pitchDown = 34f;
	static final float pitchUp = -47f;
	static final float pitchDownSpeed = 0.5f;
	static final int pitchUpHeight = 5;
	static final double pitchUpVelocity = 5f;
	private FlyState state = FlyState.NOT_FLYING;
	private static class_304 toggleKeybind;
	private float pitch;
	private double lowest_y;

	@Override
	public void onInitializeClient() {
		toggleKeybind = KeyBindingHelper.registerKeyBinding(new class_304(
				"key.elytrainfinite.toggle",
				GLFW.GLFW_KEY_H,
				"category.elytrainfinite"));
		ClientTickEvents.START_WORLD_TICK.register(world -> {
			if (state == FlyState.TOGGLED_OFF)
				return;
			class_746 player = class_310.method_1551().field_1724;
			if (player == null || !player.method_6128()) {
				state = FlyState.NOT_FLYING;
				return;
			}
			if (state == FlyState.NOT_FLYING) {
				state = FlyState.GLIDING_DOWN;
				pitch = pitchDown;
			}
			if (state == FlyState.PITCHING_DOWN) {
				pitch += Math.min(pitchDown - pitch, pitchDownSpeed); // change pitch by no more than pitchDownSpeed
				if (pitch >= pitchDown || (player.method_18798().field_1351 <= 0 && player.method_23318() > lowest_y)) {
					pitch = pitchDown;
					state = FlyState.GLIDING_DOWN; // when fully pitched down OR moving downwards, start gliding
				}
			}
			if (state == FlyState.GLIDING_DOWN) {
				class_2338 pos = player.method_24515();
				int height = world.method_22350(pos).method_12005(class_2902.class_2903.field_13202, pos.method_10263(), pos.method_10260());
				if (pos.method_10264() - height < pitchUpHeight || player.method_18798().method_1027() > pitchUpVelocity) {
					pitch = pitchUp;
					state = FlyState.PITCHING_DOWN;
					lowest_y = player.method_23318();
				}
			}
			player.method_36457(pitch);
		});
		ClientTickEvents.END_CLIENT_TICK.register(client -> {
			while (toggleKeybind.method_1436()) {
				class_5250 msg = class_2561.method_43471("category.elytrainfinite");
				msg.method_27693(" ");
				if (state == FlyState.TOGGLED_OFF) {
					state = FlyState.NOT_FLYING;
					msg.method_10852(class_2561.method_43471("message.elytrainfinite.on").method_27692(class_124.field_1060));
				} else {
					state = FlyState.TOGGLED_OFF;
					msg.method_10852(class_2561.method_43471("message.elytrainfinite.off").method_27692(class_124.field_1061));
				}
				client.field_1724.method_7353(msg, true);
			}
		});
		UseItemCallback.EVENT.register((player, world, hand) -> {
			if (player.method_5998(hand).method_7909() == class_1802.field_8639 && state != FlyState.TOGGLED_OFF
					&& !player.method_7325() && player.method_6128()) {
				player.method_36457(pitchUp);
				pitch = pitchUp;
				state = FlyState.PITCHING_DOWN;
				lowest_y = player.method_23318();
			}
			return class_1269.field_5811;
		});
		LOGGER.info("Elytra Infinite loaded.");
	}
}