package meanwhile131.elytrainfinite;

import net.fabricmc.api.ClientModInitializer;

import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import meanwhile131.elytrainfinite.mixin.LivingEntityInvoker;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_746;

enum FlyState {
    TOGGLED_OFF,
    NOT_FLYING,
    PITCHING_DOWN,
    GLIDING_DOWN
};

public class ElytraInfinite
        implements ClientModInitializer, ClientTickEvents.StartWorldTick, ClientTickEvents.EndTick, UseItemCallback {
    public static final String MOD_ID = "elytra-infinite";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static ModConfig CONFIG;
    private FlyState state = FlyState.NOT_FLYING;
    private static class_304 toggleKeybind;
    private float pitch;
    private double lowest_y;

    @Override
    public void onInitializeClient() {
        ModConfig.HANDLER.load();
        CONFIG = ModConfig.HANDLER.instance();
        class_304.class_11900 keybindCategory = class_304.class_11900.method_74698(class_2960.method_60654("elytrainfinite"));
        toggleKeybind = KeyBindingHelper.registerKeyBinding(new class_304(
                "key.elytrainfinite.toggle",
                GLFW.GLFW_KEY_H,
                keybindCategory));
        ClientTickEvents.START_WORLD_TICK.register(this);
        ClientTickEvents.END_CLIENT_TICK.register(this);
        UseItemCallback.EVENT.register(this);
        LOGGER.info("Elytra Infinite loaded.");
    }

    @Override
    public void onStartTick(class_638 world) {
        if (state == FlyState.TOGGLED_OFF)
            return;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || !player.method_6128()) {
            state = FlyState.NOT_FLYING;
            return;
        }
        if (state == FlyState.NOT_FLYING) { // we weren't flying, but now are: pitch down to get speed
            state = FlyState.GLIDING_DOWN;
            pitch = CONFIG.pitchDown;
        }
        if (state == FlyState.PITCHING_DOWN) {
            pitch += Math.min(CONFIG.pitchDown - pitch, CONFIG.pitchDownSpeed); // change pitch by no more than
                                                                                // pitchDownSpeed

            // check we are above lowest_y to prevent instantly pitching down from leftover
            // downwards velocity after gliding down
            boolean movingDownwards = player.method_18798().field_1351 <= 0 && player.method_23318() > lowest_y;

            if (pitch >= CONFIG.pitchDown || movingDownwards) {
                pitch = CONFIG.pitchDown;
                state = FlyState.GLIDING_DOWN;
            }
        }
        if (state == FlyState.GLIDING_DOWN) {
            boolean willCollide = this.willCollideWhileGliding(player, CONFIG.ticksCollisionLookAhead);

            if (willCollide || player.method_18798().method_37268() > Math.pow(CONFIG.pitchUpVelocity, 2)) {
                pitch = CONFIG.pitchUp;
                state = FlyState.PITCHING_DOWN;
                lowest_y = player.method_23318();
            }
        }
        player.method_36457(pitch);
    }

    @Override
    public void onEndTick(class_310 client) {
        while (toggleKeybind.method_1436()) {
            class_5250 msg = class_2561.method_43471("category.elytrainfinite");
            msg.method_27693(" ");
            if (state == FlyState.TOGGLED_OFF) {
                state = FlyState.NOT_FLYING;
                msg.method_10852(class_2561.method_43471("message.elytrainfinite.on").method_27692(class_124.field_1060));
            } else {
                state = FlyState.TOGGLED_OFF;
                msg.method_10852(class_2561.method_43471("message.elytrainfinite.off").method_27692(class_124.field_1061));
            }
            client.field_1724.method_7353(msg, true);
        }
    }

    @Override
    public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand) {
        if (player.method_5998(hand).method_7909() == class_1802.field_8639 && state != FlyState.TOGGLED_OFF
                && !player.method_7325() && player.method_6128()) {
            pitch = CONFIG.pitchUp;
            player.method_36457(pitch);
            state = FlyState.PITCHING_DOWN;
            lowest_y = player.method_23318();
        }
        return class_1269.field_5811;
    }

    private boolean willCollideWhileGliding(class_746 player, int ticks) {
        LivingEntityInvoker glidingPlayer = (LivingEntityInvoker) player;
        class_243 velocity = player.method_18798();
        class_238 boundingBox = player.method_5829();
        for (int i = 0; i < ticks; i++) {
            velocity = glidingPlayer.invokeCalcGlidingVelocity(velocity);
            boundingBox = boundingBox.method_997(velocity);
            if (!player.method_73183().method_61716(null, boundingBox, true)) {
                return true;
            }
        }
        return false;
    }
}