/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage_grinder.content.kinetics.grinder;

import com.google.gson.JsonObject;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.bluephs.vintage_grinder.VintageBlocks;
import dev.bluephs.vintage_grinder.VintageLang;
import dev.bluephs.vintage_grinder.VintageRecipes;
import dev.bluephs.vintage_grinder.compat.jei.category.assemblies.AssemblyPolishing;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class PolishingRecipe
extends ProcessingRecipe<RecipeWrapper>
implements IAssemblyRecipe {
    int speedLimits = 0;
    boolean fragile = false;

    public PolishingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)VintageRecipes.POLISHING, params);
    }

    public void readAdditional(JsonObject json) {
        this.speedLimits = json.has("speedLimits") ? json.get("speedLimits").getAsInt() : (json.has("speed_limits") ? json.get("speed_limits").getAsInt() : 0);
        this.fragile = json.has("fragile") ? json.get("fragile").getAsBoolean() : false;
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        this.speedLimits = buffer.readInt();
        this.fragile = buffer.readBoolean();
    }

    public void writeAdditional(JsonObject json) {
        json.addProperty("speedLimits", (Number)this.speedLimits);
        json.addProperty("fragile", Boolean.valueOf(this.fragile));
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.speedLimits);
        buffer.writeBoolean(this.fragile);
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        if (inv.m_7983_()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(inv.m_8020_(0));
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        MutableComponent result = VintageLang.translateDirect("recipe.assembly.polishing", new Object[0]);
        result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.on", new Object[0])).m_130946_(" ");
        switch (this.speedLimits) {
            case 1: {
                result.m_7220_((Component)VintageLang.translateDirect("recipe.assembly.low", new Object[0]));
                break;
            }
            case 2: {
                result.m_7220_((Component)VintageLang.translateDirect("recipe.assembly.medium", new Object[0]));
                break;
            }
            case 3: {
                result.m_7220_((Component)VintageLang.translateDirect("recipe.assembly.high", new Object[0]));
                break;
            }
            default: {
                result.m_7220_((Component)VintageLang.translateDirect("recipe.assembly.any", new Object[0]));
            }
        }
        result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.speed", new Object[0]));
        return result;
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)VintageBlocks.BELT_GRINDER.get());
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> AssemblyPolishing::new;
    }

    public int getSpeedLimits() {
        return this.speedLimits;
    }

    public boolean isFragile() {
        return this.fragile;
    }
}

