/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage_grinder.foundation.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum VintageGuiTextures implements ScreenElement
{
    JEI_UP_ARROW("jei/widgets", 0, 0, 18, 14),
    JEI_UP_TO_RIGHT_ARROW("jei/widgets", 17, 0, 14, 18),
    JEI_FRAGILE("jei/widgets", 31, 0, 14, 23);

    public static final int FONT_COLOR = 5726074;
    public final ResourceLocation location;
    public int width;
    public int height;
    public int startX;
    public int startY;

    private VintageGuiTextures(String location, int width, int height) {
        this(location, 0, 0, width, height);
    }

    private VintageGuiTextures(int startX, int startY) {
        this("icons", startX * 16, startY * 16, 16, 16);
    }

    private VintageGuiTextures(String location, int startX, int startY, int width, int height) {
        this("vintage_grinder", location, startX, startY, width, height);
    }

    private VintageGuiTextures(String namespace, String location, int startX, int startY, int width, int height) {
        this.location = new ResourceLocation(namespace, "textures/gui/" + location + ".png");
        this.width = width;
        this.height = height;
        this.startX = startX;
        this.startY = startY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bind() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y) {
        graphics.m_280218_(this.location, x, y, this.startX, this.startY, this.width, this.height);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y, Color c) {
        this.bind();
        UIRenderHelper.drawColoredTexture((GuiGraphics)graphics, (Color)c, (int)x, (int)y, (int)this.startX, (int)this.startY, (int)this.width, (int)this.height);
    }
}

