/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage_grinder;

import com.mojang.logging.LogUtils;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import dev.bluephs.vintage_grinder.VintageBlockEntity;
import dev.bluephs.vintage_grinder.VintageBlocks;
import dev.bluephs.vintage_grinder.VintagePartialModels;
import dev.bluephs.vintage_grinder.VintageRecipes;
import dev.bluephs.vintage_grinder.VintageRecipesList;
import dev.bluephs.vintage_grinder.content.kinetics.grinder.GrinderBlock;
import dev.bluephs.vintage_grinder.foundation.advancement.VintageAdvancements;
import dev.bluephs.vintage_grinder.infrastructure.config.VintageConfig;
import dev.bluephs.vintage_grinder.infrastructure.ponder.VintagePonderPlugin;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="vintage_grinder")
public class VintageGrinder {
    public static final String MOD_ID = "vintage_grinder";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate MY_REGISTRATE = CreateRegistrate.create((String)"vintage_grinder");
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static final RegistryObject<Item> GRINDER_BELT;
    public static boolean useEnergy;
    public static final RegistryObject<CreativeModeTab> VINTAGE_TAB;

    public static void logThis(String str) {
        LOGGER.info(str);
    }

    public VintageGrinder() {
        VintageGrinder.onCtor();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void onCtor() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        MY_REGISTRATE.registerEventListeners(modEventBus);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        VintageBlocks.register();
        VintageBlockEntity.register();
        VintageRecipes.register(modEventBus);
        VintagePartialModels.init();
        modEventBus.addListener(VintageGrinder::commonSetup);
        VintageConfig.register(modLoadingContext);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(VintageAdvancements::register);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        VintageRecipesList.init(event.getServer());
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static {
        MY_REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MOD_ID);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MOD_ID);
        CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)MOD_ID);
        GRINDER_BELT = ITEMS.register("grinder_belt", () -> new Item(new Item.Properties()));
        useEnergy = false;
        VINTAGE_TAB = CREATIVE_MODE_TABS.register("vintage_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257941_((Component)Component.m_237115_((String)"itemGroup.vintage_grinder")).m_257737_(() -> ((GrinderBlock)((Object)((Object)((Object)VintageBlocks.BELT_GRINDER.get())))).m_5456_().m_7968_()).m_257501_((parameters, output) -> {
            boolean forceItems = (Boolean)VintageConfig.client().forceCompatItemsIntoCreativeTab.get();
            output.m_246326_((ItemLike)VintageBlocks.BELT_GRINDER.get());
            output.m_246326_((ItemLike)GRINDER_BELT.get());
            if (((Boolean)VintageConfig.client().legacyMaterialsIntoCreativeTab.get()).booleanValue()) {
                output.m_246326_((ItemLike)AllItems.REFINED_RADIANCE);
                output.m_246326_((ItemLike)AllItems.SHADOW_STEEL);
            }
        }).m_257652_());
    }

    @Mod.EventBusSubscriber(modid="vintage_grinder", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            PonderIndex.addPlugin((PonderPlugin)new VintagePonderPlugin());
        }
    }
}

