/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage_grinder.compat.jei;

import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import dev.bluephs.vintage_grinder.VintageBlocks;
import dev.bluephs.vintage_grinder.VintageGrinder;
import dev.bluephs.vintage_grinder.VintageRecipes;
import dev.bluephs.vintage_grinder.VintageRecipesList;
import dev.bluephs.vintage_grinder.compat.jei.category.GrinderPolishingCategory;
import dev.bluephs.vintage_grinder.compat.jei.category.GrinderSandpaperPolishingCategory;
import dev.bluephs.vintage_grinder.content.kinetics.grinder.PolishingRecipe;
import dev.bluephs.vintage_grinder.infrastructure.config.VCRecipes;
import dev.bluephs.vintage_grinder.infrastructure.config.VintageConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class VintageJEI
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("vintage_grinder", "jei_plugin");
    public IIngredientManager ingredientManager;
    final List<CreateRecipeCategory<?>> ALL = new ArrayList();

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.ALL.clear();
        this.ALL.add(this.builder(PolishingRecipe.class).addTypedRecipes(VintageRecipes.POLISHING::getType).catalyst(() -> VintageBlocks.BELT_GRINDER.get()).itemIcon((ItemLike)VintageBlocks.BELT_GRINDER.get()).emptyBackground(177, 85).build("polishing", GrinderPolishingCategory::new));
        this.ALL.add(this.builder(SandPaperPolishingRecipe.class).enableWhen(c -> c.allowSandpaperPolishingOnGrinder).addAllRecipesIf(r -> r instanceof SandPaperPolishingRecipe && VintageRecipesList.isPolishing(r)).catalyst(() -> VintageBlocks.BELT_GRINDER.get()).doubleItemIcon((ItemLike)VintageBlocks.BELT_GRINDER.get(), (ItemLike)AllItems.SAND_PAPER).emptyBackground(177, 85).build("grinder_sandpaper_polishing", (CreateRecipeCategory.Factory<SandPaperPolishingRecipe>)((CreateRecipeCategory.Factory)GrinderSandpaperPolishingCategory::new)));
        this.ALL.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.ALL.forEach(c -> c.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        this.ALL.forEach(c -> c.registerCatalysts(registration));
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    private static class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<VCRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<VCRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((VCRecipes)((Object)c))).get();
            return this;
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public void icon(IDrawable icon) {
            this.icon = icon;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public void background(IDrawable background) {
            this.background = background;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
                }
            }));
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(VintageConfig.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : Collections::emptyList;
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(VintageGrinder.asResource(name), this.recipeClass), (Component)Component.m_237115_((String)("vintage_grinder.recipe." + name)), this.background, this.icon, recipesSupplier, this.catalysts);
            return factory.create(info);
        }
    }
}

