/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage_grinder.compat.kubejs.recipes;

import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.recipe.BlockTagIngredient;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.item.ingredient.TagContext;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.BooleanComponent;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public interface PolishingRecipeSchema {
    public static final RecipeKey<OutputItem[]> RESULTS = ItemComponents.OUTPUT_ARRAY.key("results");
    public static final RecipeKey<InputItem[]> INGREDIENT = ItemComponents.INPUT_ARRAY.key("ingredients");
    public static final RecipeKey<Long> PROCESSING_TIME_REQUIRED = TimeComponent.TICKS.key("processingTime").optional((Object)100L).alwaysWrite();
    public static final RecipeKey<Boolean> FRAGILE = BooleanComponent.BOOLEAN.key("fragile").optional((Object)false);
    public static final RecipeKey<Integer> SPEED_LIMIT = NumberComponent.IntRange.INT.key("speedLimits").optional((Object)0);
    public static final RecipeSchema POLISHING_PROCESSING = new RecipeSchema(ProcessingRecipeJS.class, ProcessingRecipeJS::new, new RecipeKey[]{RESULTS, INGREDIENT, PROCESSING_TIME_REQUIRED, SPEED_LIMIT, FRAGILE});

    public static class ProcessingRecipeJS
    extends RecipeJS {
        public boolean inputItemHasPriority(Object from) {
            if (from instanceof InputItem || from instanceof Ingredient || from instanceof ItemStack) {
                return true;
            }
            InputItem input = this.readInputItem(from);
            Ingredient ingredient = input.ingredient;
            if (ingredient instanceof BlockTagIngredient) {
                BlockTagIngredient blockTag = (BlockTagIngredient)ingredient;
                return !((TagContext)TagContext.INSTANCE.getValue()).isEmpty(blockTag.getTag());
            }
            return !input.isEmpty();
        }

        public OutputItem readOutputItem(Object from) {
            JsonObject j;
            if (from instanceof ProcessingOutput) {
                ProcessingOutput output = (ProcessingOutput)from;
                return OutputItem.of((ItemStack)output.getStack(), (double)output.getChance());
            }
            OutputItem outputItem = super.readOutputItem(from);
            if (from instanceof JsonObject && (j = (JsonObject)from).has("chance")) {
                return outputItem.withChance((double)j.get("chance").getAsFloat());
            }
            return outputItem;
        }

        public RecipeJS fragile() {
            return this.setValue(FRAGILE, true);
        }

        public RecipeJS speedLimits(int limits) {
            return this.setValue(SPEED_LIMIT, limits);
        }
    }
}

