/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import jn.willfrydev.xchat.commands.IgnoreCommand;
import jn.willfrydev.xchat.commands.MessageCommand;
import jn.willfrydev.xchat.commands.ReplyCommand;
import jn.willfrydev.xchat.commands.SocialSpyCommand;
import jn.willfrydev.xchat.commands.XChatCommand;
import jn.willfrydev.xchat.listeners.ChatListener;
import jn.willfrydev.xchat.listeners.ChatPacketListener;
import jn.willfrydev.xchat.manager.IgnoreManager;
import jn.willfrydev.xchat.utils.Metrics;
import jn.willfrydev.xchat.utils.UpdateChecker;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class XChat
extends JavaPlugin {
    private IgnoreManager ignoreManager;
    private MiniMessage miniMessage;
    private LegacyComponentSerializer legacySerializer;
    private Chat vaultChat = null;
    private final Map<UUID, UUID> lastMessageSender = new HashMap<UUID, UUID>();
    private final Set<UUID> socialSpyUsers = new HashSet<UUID>();

    public void onEnable() {
        String[] logo;
        for (String line : logo = new String[]{"        ___ _           _   ", " __  __ / __\\ |__   __ _| |_ ", " \\ \\/ // /  | '_ \\ / _` | __|", "  >  </ /___| | | | (_| | |_ ", " /_/\\_\\____/|_| |_|\\__,_|\\__|", ""}) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&b" + line)));
        }
        this.saveDefaultConfig();
        int pluginId = 27335;
        new Metrics(this, pluginId);
        if (this.getConfig().getBoolean("update-checker.enabled")) {
            new UpdateChecker(this, "xchat").check();
        }
        this.miniMessage = MiniMessage.miniMessage();
        this.ignoreManager = new IgnoreManager(this);
        this.legacySerializer = LegacyComponentSerializer.builder().character('&').hexColors().build();
        if (!this.setupChat()) {
            this.getLogger().warning("Vault no encontrado. Los formatos por grupo estar\u00e1n desactivados.");
        } else {
            this.getLogger().info("Conectado con Vault para los formatos de grupo.");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        if (this.getServer().getPluginManager().getPlugin("ProtocolLib") != null) {
            new ChatPacketListener(this).register();
            this.getLogger().info("ProtocolLib detectado. El listener de packets ha sido activado.");
        } else {
            this.getLogger().warning("ProtocolLib no encontrado. Las funciones avanzadas de packets estar\u00e1n desactivadas.");
        }
        this.getCommand("xchat").setExecutor((CommandExecutor)new XChatCommand(this));
        IgnoreCommand ignoreExecutor = new IgnoreCommand(this);
        this.getCommand("ignore").setExecutor((CommandExecutor)ignoreExecutor);
        this.getCommand("ignore").setTabCompleter((TabCompleter)ignoreExecutor);
        this.getCommand("msg").setExecutor((CommandExecutor)new MessageCommand(this));
        this.getCommand("reply").setExecutor((CommandExecutor)new ReplyCommand(this));
        this.getCommand("socialspy").setExecutor((CommandExecutor)new SocialSpyCommand(this));
        this.getLogger().info("xChat v" + this.getDescription().getVersion() + " ha sido activado correctamente.");
    }

    public void onDisable() {
        if (this.ignoreManager != null) {
            this.ignoreManager.save();
        }
        this.getLogger().info("xChat ha sido desactivado.");
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cGracias por usar xChat!"));
    }

    public void reloadPlugin() {
        this.reloadConfig();
        if (this.getIgnoreManager() != null) {
            this.getIgnoreManager().load();
        }
        this.getLogger().info("Configuraci\u00f3n de xChat recargada.");
    }

    private boolean setupChat() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Chat.class);
        if (rsp == null) {
            return false;
        }
        this.vaultChat = (Chat)rsp.getProvider();
        return this.vaultChat != null;
    }

    public IgnoreManager getIgnoreManager() {
        return this.ignoreManager;
    }

    public MiniMessage getMiniMessage() {
        return this.miniMessage;
    }

    public LegacyComponentSerializer getLegacySerializer() {
        return this.legacySerializer;
    }

    public Chat getVaultChat() {
        return this.vaultChat;
    }

    public Map<UUID, UUID> getLastMessageSender() {
        return this.lastMessageSender;
    }

    public Set<UUID> getSocialSpyUsers() {
        return this.socialSpyUsers;
    }
}

