/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat.commands;

import java.util.Arrays;
import java.util.UUID;
import jn.willfrydev.xchat.XChat;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MessageCommand
implements CommandExecutor {
    private final XChat plugin;

    public MessageCommand(XChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Este comando solo puede ser usado por jugadores.");
            return true;
        }
        if (args.length < 2) {
            this.sendMessage(sender, "pm.messages.usage", new String[][]{{"{label}", label}});
            return true;
        }
        Player playerSender = (Player)sender;
        Player playerReceiver = Bukkit.getPlayer((String)args[0]);
        if (playerReceiver == null) {
            this.sendMessage(sender, "pm.messages.player-not-found", new String[0][]);
            return true;
        }
        if (playerSender.equals(playerReceiver)) {
            this.sendMessage(sender, "pm.messages.cannot-message-self", new String[0][]);
            return true;
        }
        String messageContent = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        this.sendMessageLogic(playerSender, playerReceiver, messageContent);
        return true;
    }

    public void sendMessageLogic(Player sender, Player receiver, String message) {
        String senderFormat = this.plugin.getConfig().getString("pm.format.sender");
        String receiverFormat = this.plugin.getConfig().getString("pm.format.receiver");
        senderFormat = senderFormat.replace("%message%", message);
        receiverFormat = receiverFormat.replace("%message%", message);
        String finalSenderFormat = PlaceholderAPI.setPlaceholders((Player)sender, (String)senderFormat);
        finalSenderFormat = PlaceholderAPI.setPlaceholders((Player)receiver, (String)finalSenderFormat);
        sender.sendMessage((Component)this.plugin.getLegacySerializer().deserialize(finalSenderFormat));
        String finalReceiverFormat = PlaceholderAPI.setPlaceholders((Player)sender, (String)receiverFormat);
        finalReceiverFormat = PlaceholderAPI.setPlaceholders((Player)receiver, (String)finalReceiverFormat);
        receiver.sendMessage((Component)this.plugin.getLegacySerializer().deserialize(finalReceiverFormat));
        this.plugin.getLastMessageSender().put(sender.getUniqueId(), receiver.getUniqueId());
        this.plugin.getLastMessageSender().put(receiver.getUniqueId(), sender.getUniqueId());
        try {
            String soundName = this.plugin.getConfig().getString("pm.sound", "ENTITY_EXPERIENCE_ORB_PICKUP");
            receiver.playSound(receiver.getLocation(), Sound.valueOf((String)soundName.toUpperCase()), 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("El sonido '" + this.plugin.getConfig().getString("pm.sound") + "' no es v\u00e1lido.");
        }
        if (this.plugin.getConfig().getBoolean("pm.social-spy.enabled")) {
            String spyFormat = this.plugin.getConfig().getString("pm.social-spy.format", "&8[SPY] %sender_name% -> %receiver_name%: &f");
            spyFormat = spyFormat.replace("%sender_name%", sender.getName()).replace("%receiver_name%", receiver.getName());
            Component spyComponent = this.plugin.getLegacySerializer().deserialize(spyFormat).append((Component)Component.text((String)message));
            for (UUID uuid : this.plugin.getSocialSpyUsers()) {
                Player spy = Bukkit.getPlayer((UUID)uuid);
                if (spy == null || uuid.equals(sender.getUniqueId()) || uuid.equals(receiver.getUniqueId())) continue;
                spy.sendMessage(spyComponent);
            }
        }
    }

    private void sendMessage(CommandSender sender, String path, String[] ... replacements) {
        String message = this.plugin.getConfig().getString("pm.messages." + path, "&cMensaje no encontrado.");
        for (String[] replacement : replacements) {
            message = message.replace(replacement[0], replacement[1]);
        }
        sender.sendMessage((Component)this.plugin.getLegacySerializer().deserialize(message));
    }
}

