/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat.commands;

import jn.willfrydev.xchat.XChat;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class XChatCommand
implements CommandExecutor {
    private final XChat plugin;

    public XChatCommand(XChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("xchat.reload")) {
                this.sendMessage(sender, "no-permission");
                return true;
            }
            this.plugin.reloadPlugin();
            this.sendMessage(sender, "reload");
            return true;
        }
        this.sendHelpList(sender, "help-message.xchat");
        return true;
    }

    private void sendMessage(CommandSender sender, String key) {
        String message = this.plugin.getConfig().getString("plugin-messages." + key, "&cMensaje no encontrado.");
        sender.sendMessage((Component)this.plugin.getLegacySerializer().deserialize(message));
    }

    private void sendHelpList(CommandSender sender, String path) {
        for (String line : this.plugin.getConfig().getStringList(path)) {
            sender.sendMessage((Component)this.plugin.getLegacySerializer().deserialize(line));
        }
    }
}

