/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat.listeners;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import jn.willfrydev.xchat.XChat;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class ChatListener
implements Listener {
    private final XChat plugin;
    private final Map<UUID, Long> chatCooldowns = new HashMap<UUID, Long>();

    public ChatListener(XChat plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerChat(AsyncChatEvent event) {
        Component finalMessage;
        Player sender = event.getPlayer();
        if (this.plugin.getConfig().getBoolean("anti-spam.enabled") && !sender.hasPermission("xchat.antispam.bypass") && this.handleCooldown(sender)) {
            event.setCancelled(true);
            return;
        }
        Chat vaultChat = this.plugin.getVaultChat();
        String playerGroup = null;
        if (vaultChat != null) {
            playerGroup = vaultChat.getPrimaryGroup(sender);
        }
        String groupFormatPath = "groups." + playerGroup;
        if (playerGroup != null && this.plugin.getConfig().isSet(groupFormatPath)) {
            String format = this.plugin.getConfig().getString(groupFormatPath);
            format = PlaceholderAPI.setPlaceholders((Player)sender, (String)format);
            String plainMessage = ((TextComponent)event.message()).content();
            format = format.replace("%message%", plainMessage);
            finalMessage = this.plugin.getLegacySerializer().deserialize(format);
        } else {
            finalMessage = this.buildDefaultHoverMessage(sender, event.message());
        }
        event.renderer((source, sourceDisplayName, message, viewer) -> {
            if (viewer instanceof Player) {
                Player recipient = (Player)viewer;
                if (this.plugin.getIgnoreManager().isIgnoring(recipient.getUniqueId(), source.getUniqueId())) {
                    return Component.empty();
                }
            }
            return finalMessage;
        });
    }

    private Component buildDefaultHoverMessage(Player sender, Component message) {
        String format = this.plugin.getConfig().getString("hover-format.default.format", "&f%player_name%");
        String hoverDescription = this.plugin.getConfig().getString("hover-format.default.descripcion", "");
        String clickAction = this.plugin.getConfig().getString("hover-format.default.click", "");
        String hoverText = String.join((CharSequence)"\n", this.plugin.getConfig().getStringList("hover-format.default.lines"));
        format = PlaceholderAPI.setPlaceholders((Player)sender, (String)format);
        hoverDescription = PlaceholderAPI.setPlaceholders((Player)sender, (String)hoverDescription);
        clickAction = PlaceholderAPI.setPlaceholders((Player)sender, (String)clickAction);
        hoverText = PlaceholderAPI.setPlaceholders((Player)sender, (String)hoverText);
        LegacyComponentSerializer serializer = this.plugin.getLegacySerializer();
        TextComponent mainComponent = serializer.deserialize(format);
        TextComponent hoverComponent = serializer.deserialize(hoverDescription + "\n" + hoverText);
        mainComponent = mainComponent.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent)).clickEvent(ClickEvent.suggestCommand((String)clickAction));
        Component messageComponent = message;
        if (sender.hasPermission("xchat.colors")) {
            String plainMessage = ((TextComponent)message).content();
            messageComponent = serializer.deserialize(plainMessage);
        }
        return mainComponent.append((Component)Component.text((String)":")).append((Component)Component.space()).append(messageComponent);
    }

    private boolean handleCooldown(Player sender) {
        long delayMillis;
        long lastChatTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastChatTime = this.chatCooldowns.getOrDefault(sender.getUniqueId(), 0L).longValue()) < (delayMillis = TimeUnit.SECONDS.toMillis(this.plugin.getConfig().getLong("anti-spam.delay-seconds")))) {
            long timeLeft = TimeUnit.MILLISECONDS.toSeconds(delayMillis - (currentTime - lastChatTime)) + 1L;
            String spamMessage = this.plugin.getConfig().getString("anti-spam.message");
            sender.sendMessage((Component)this.plugin.getLegacySerializer().deserialize(spamMessage.replace("%time%", String.valueOf(timeLeft))));
            return true;
        }
        this.chatCooldowns.put(sender.getUniqueId(), currentTime);
        return false;
    }
}

