/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat.manager;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import jn.willfrydev.xchat.XChat;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class IgnoreManager {
    private final XChat plugin;
    private final File ignoreFile;
    private final FileConfiguration ignoreConfig;
    private final Map<UUID, Set<UUID>> ignoreMap = new HashMap<UUID, Set<UUID>>();

    public IgnoreManager(XChat plugin) {
        this.plugin = plugin;
        this.ignoreFile = new File(plugin.getDataFolder(), "ignores.yml");
        if (!this.ignoreFile.exists()) {
            plugin.saveResource("ignores.yml", false);
        }
        this.ignoreConfig = YamlConfiguration.loadConfiguration((File)this.ignoreFile);
        this.load();
    }

    public void addIgnore(UUID player, UUID target) {
        this.ignoreMap.computeIfAbsent(player, k -> new HashSet()).add(target);
    }

    public void removeIgnore(UUID player, UUID target) {
        this.ignoreMap.getOrDefault(player, Collections.emptySet()).remove(target);
    }

    public boolean isIgnoring(UUID player, UUID target) {
        return this.ignoreMap.getOrDefault(player, Collections.emptySet()).contains(target);
    }

    public Set<UUID> getIgnoredPlayers(UUID player) {
        return this.ignoreMap.getOrDefault(player, Collections.emptySet());
    }

    public void load() {
        this.ignoreMap.clear();
        ConfigurationSection section = this.ignoreConfig.getConfigurationSection("ignored");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            try {
                UUID playerUUID = UUID.fromString(key);
                HashSet<UUID> ignored = new HashSet<UUID>();
                for (String ignoredStr : section.getStringList(key)) {
                    ignored.add(UUID.fromString(ignoredStr));
                }
                this.ignoreMap.put(playerUUID, ignored);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("UUID inv\u00e1lido en ignores.yml: " + key);
            }
        }
    }

    public void save() {
        this.ignoreConfig.set("ignored", null);
        ConfigurationSection section = this.ignoreConfig.createSection("ignored");
        for (Map.Entry<UUID, Set<UUID>> entry : this.ignoreMap.entrySet()) {
            List ignoredUUIDs = entry.getValue().stream().map(UUID::toString).collect(Collectors.toList());
            section.set(entry.getKey().toString(), ignoredUUIDs);
        }
        try {
            this.ignoreConfig.save(this.ignoreFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("No se pudo guardar el archivo ignores.yml");
            e.printStackTrace();
        }
    }
}

