/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import jn.willfrydev.xchat.commands.AnnounceCommand;
import jn.willfrydev.xchat.commands.CountdownCommand;
import jn.willfrydev.xchat.commands.DiscordCommand;
import jn.willfrydev.xchat.commands.IgnoreCommand;
import jn.willfrydev.xchat.commands.LiveCommand;
import jn.willfrydev.xchat.commands.MessageCommand;
import jn.willfrydev.xchat.commands.PingCommand;
import jn.willfrydev.xchat.commands.ReplyCommand;
import jn.willfrydev.xchat.commands.SocialSpyCommand;
import jn.willfrydev.xchat.commands.SubtitleCommand;
import jn.willfrydev.xchat.commands.WebsiteCommand;
import jn.willfrydev.xchat.commands.XChatCommand;
import jn.willfrydev.xchat.listeners.ChatListener;
import jn.willfrydev.xchat.listeners.UnknownCommandListener;
import jn.willfrydev.xchat.listeners.WelcomeListener;
import jn.willfrydev.xchat.manager.FilterManager;
import jn.willfrydev.xchat.manager.IgnoreManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class XChat
extends JavaPlugin {
    private IgnoreManager ignoreManager;
    private FilterManager filterManager;
    private LegacyComponentSerializer legacySerializer;
    private Chat vaultChat = null;
    private boolean placeholderApiEnabled = false;
    private File messagesFile;
    private FileConfiguration messagesConfig;
    private final Map<UUID, UUID> lastMessageSender = new HashMap<UUID, UUID>();
    private final Set<UUID> socialSpyUsers = new HashSet<UUID>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.createMessagesConfig();
        this.loadManagers();
        this.setupDependencies();
        this.registerListeners();
        this.registerCommands();
        this.getLogger().info("xChat v" + this.getDescription().getVersion() + " by xPlugins x WillfryDev has been enabled!");
    }

    public void onDisable() {
        if (this.ignoreManager != null) {
            this.ignoreManager.save();
        }
        this.getLogger().info("xChat has been disabled.");
    }

    private void loadManagers() {
        this.legacySerializer = LegacyComponentSerializer.builder().character('&').hexColors().useUnusualXRepeatedCharacterHexFormat().build();
        this.ignoreManager = new IgnoreManager(this);
        this.filterManager = new FilterManager(this);
    }

    private void setupDependencies() {
        if (!this.setupChat()) {
            this.getLogger().warning("Vault not found. Group formats will be disabled.");
        } else {
            this.getLogger().info("Successfully hooked into Vault for group formats.");
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.placeholderApiEnabled = true;
            this.getLogger().info("Successfully hooked into PlaceholderAPI.");
        }
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        if (this.getConfig().getBoolean("modules.welcome-message")) {
            this.getServer().getPluginManager().registerEvents((Listener)new WelcomeListener(this), (Plugin)this);
        }
        if (this.getConfig().getBoolean("modules.unknown-command-handler")) {
            this.getServer().getPluginManager().registerEvents((Listener)new UnknownCommandListener(this), (Plugin)this);
        }
    }

    private void registerCommands() {
        this.getCommand("xchat").setExecutor((CommandExecutor)new XChatCommand(this));
        this.getCommand("ignore").setExecutor((CommandExecutor)new IgnoreCommand(this));
        this.getCommand("msg").setExecutor((CommandExecutor)new MessageCommand(this));
        this.getCommand("reply").setExecutor((CommandExecutor)new ReplyCommand(this));
        this.getCommand("socialspy").setExecutor((CommandExecutor)new SocialSpyCommand(this));
        this.getCommand("announce").setExecutor((CommandExecutor)new AnnounceCommand(this));
        this.getCommand("countdown").setExecutor((CommandExecutor)new CountdownCommand(this));
        this.getCommand("discord").setExecutor((CommandExecutor)new DiscordCommand(this));
        this.getCommand("live").setExecutor((CommandExecutor)new LiveCommand(this));
        this.getCommand("ping").setExecutor((CommandExecutor)new PingCommand(this));
        this.getCommand("subtitle").setExecutor((CommandExecutor)new SubtitleCommand(this));
        this.getCommand("website").setExecutor((CommandExecutor)new WebsiteCommand(this));
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.loadMessagesConfig();
        this.getIgnoreManager().load();
        this.getFilterManager().loadConfig();
        this.getLogger().info("xChat configuration reloaded.");
    }

    public void sendMessage(CommandSender sender, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        String prefix = this.getMessages().getString("prefix", "&b&lxChat &8&l| &f");
        sender.sendMessage((Component)this.legacySerializer.deserialize(prefix + message));
    }

    private void createMessagesConfig() {
        this.messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void loadMessagesConfig() {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.getDataFolder(), "messages.yml");
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.getResource("messages.yml");
        if (defConfigStream != null) {
            this.messagesConfig.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, StandardCharsets.UTF_8)));
        }
    }

    private boolean setupChat() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Chat.class);
        if (rsp == null) {
            return false;
        }
        this.vaultChat = (Chat)rsp.getProvider();
        return this.vaultChat != null;
    }

    public FileConfiguration getMessages() {
        if (this.messagesConfig == null) {
            this.loadMessagesConfig();
        }
        return this.messagesConfig;
    }

    public IgnoreManager getIgnoreManager() {
        return this.ignoreManager;
    }

    public FilterManager getFilterManager() {
        return this.filterManager;
    }

    public LegacyComponentSerializer getLegacySerializer() {
        return this.legacySerializer;
    }

    public Chat getVaultChat() {
        return this.vaultChat;
    }

    public boolean isPlaceholderApiEnabled() {
        return this.placeholderApiEnabled;
    }

    public Map<UUID, UUID> getLastMessageSender() {
        return this.lastMessageSender;
    }

    public Set<UUID> getSocialSpyUsers() {
        return this.socialSpyUsers;
    }
}

