/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat.commands;

import jn.willfrydev.xchat.XChat;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class CountdownCommand
implements CommandExecutor {
    private final XChat plugin;
    private BukkitTask countdownTask = null;

    public CountdownCommand(XChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("xchat.countdown")) {
            this.plugin.sendMessage(sender, this.plugin.getMessages().getString("no-permission"));
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("stop")) {
            if (this.countdownTask != null) {
                this.countdownTask.cancel();
                this.countdownTask = null;
                this.plugin.sendMessage(sender, this.plugin.getMessages().getString("countdown.stopped"));
            }
            return true;
        }
        if (this.countdownTask != null) {
            this.plugin.sendMessage(sender, this.plugin.getMessages().getString("countdown.already-running"));
            return true;
        }
        if (args.length == 0) {
            this.plugin.sendMessage(sender, this.plugin.getMessages().getString("countdown.usage"));
            return true;
        }
        try {
            final int seconds = Integer.parseInt(args[0]);
            if (seconds <= 0) {
                throw new NumberFormatException();
            }
            this.plugin.sendMessage(sender, this.plugin.getMessages().getString("countdown.broadcast"));
            this.countdownTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){
                int time;
                {
                    this.time = seconds;
                }

                @Override
                public void run() {
                    if (this.time > 0) {
                        Bukkit.getOnlinePlayers().forEach(p -> {
                            p.sendTitle("&c" + this.time, "", 10, 20, 10);
                            p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
                        });
                        --this.time;
                    } else {
                        Bukkit.getOnlinePlayers().forEach(p -> {
                            p.sendTitle(CountdownCommand.this.plugin.getMessages().getString("countdown.finished"), "", 10, 40, 20);
                            p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                        });
                        CountdownCommand.this.countdownTask.cancel();
                        CountdownCommand.this.countdownTask = null;
                    }
                }
            }, 0L, 20L);
        }
        catch (NumberFormatException e) {
            this.plugin.sendMessage(sender, this.plugin.getMessages().getString("countdown.invalid-number"));
        }
        return true;
    }
}

